/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.execution.dashboard.backend;

import com.intellij.execution.dashboard.RunDashboardService;
import com.intellij.execution.dashboard.RunDashboardServiceId;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.platform.execution.dashboard.RunDashboardManagerImpl;
import com.intellij.platform.execution.serviceView.BackendServiceViewSelectedItemProvider;
import com.intellij.platform.ide.productMode.IdeProductMode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\r"}, d2={"Lcom/intellij/platform/execution/dashboard/backend/BackendRunDashboardSelectedItemProvider;", "Lcom/intellij/platform/execution/serviceView/BackendServiceViewSelectedItemProvider;", "<init>", "()V", "getId", "", "getSelectedItem", "Lcom/intellij/execution/dashboard/RunDashboardService;", "project", "Lcom/intellij/openapi/project/Project;", "descriptorId", "deserializeDescriptorId", "Lcom/intellij/execution/dashboard/RunDashboardServiceId;", "intellij.platform.execution.dashboard.backend"})
@SourceDebugExtension(value={"SMAP\nBackendRunDashboardSelectedItemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendRunDashboardSelectedItemProvider.kt\ncom/intellij/platform/execution/dashboard/backend/BackendRunDashboardSelectedItemProvider\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,29:1\n23#2:30\n*S KotlinDebug\n*F\n+ 1 BackendRunDashboardSelectedItemProvider.kt\ncom/intellij/platform/execution/dashboard/backend/BackendRunDashboardSelectedItemProvider\n*L\n24#1:30\n*E\n"})
public final class BackendRunDashboardSelectedItemProvider
implements BackendServiceViewSelectedItemProvider {
    @NotNull
    public String getId() {
        return "Run Dashboard";
    }

    @Nullable
    public RunDashboardService getSelectedItem(@NotNull Project project, @NotNull String descriptorId) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptorId, (String)"descriptorId");
        if (IdeProductMode.Companion.isMonolith()) {
            return null;
        }
        RunDashboardServiceId runDashboardServiceId = this.deserializeDescriptorId(descriptorId);
        if (runDashboardServiceId == null) {
            return null;
        }
        RunDashboardServiceId serviceId = runDashboardServiceId;
        return RunDashboardManagerImpl.getInstance((Project)project).findServiceById(serviceId);
    }

    private final RunDashboardServiceId deserializeDescriptorId(String descriptorId) {
        Integer backendServiceId = StringsKt.toIntOrNull((String)descriptorId);
        if (backendServiceId == null) {
            BackendRunDashboardSelectedItemProvider $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(BackendRunDashboardSelectedItemProvider.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.warn("Cannot parse descriptorId " + descriptorId);
            return null;
        }
        return new RunDashboardServiceId(backendServiceId.intValue());
    }
}

