/*
 * Decompiled with CFR 0.152.
 */
package ai.grazie.rules.en;

import ai.grazie.rules.common.CommonPatterns;
import ai.grazie.rules.en.EnglishTreePatterns;
import ai.grazie.rules.tree.NodePattern;

class Questions {
    static final NodePattern whWord = NodePattern.or(NodePattern.N.pos("WP|WDT|WP\\$?").noLemma("that"), NodePattern.N.form("how|why|where|when")).noDependents("det|goeswith|fixed").andNot(NodePattern.N.noSpaceAround().directlyAfter(EnglishTreePatterns.quotations).directlyBefore(EnglishTreePatterns.quotations));
    private static final NodePattern questionWhWord = whWord.noDependents("acl(:relcl)?|advcl:relcl");
    static final NodePattern whPhrase = NodePattern.or(questionWhWord, CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("det|nmod:poss", questionWhWord.andNot(NodePattern.N.directlyBefore(NodePattern.N.form("ever")))).noDependents("acl:relcl")), NodePattern.N.noDependents("acl").withDependent("nmod", questionWhWord), NodePattern.N.withDependent("amod", NodePattern.N.withDependent("advmod|mark", questionWhWord)), NodePattern.N.pos("RB").withDependent("mark", NodePattern.N.form("how")));
    static final NodePattern misparsedWhCcomp = NodePattern.N.withHeadRelation("i?obj|obl").and(CommonPatterns.possiblySkipDown("compound", NodePattern.N.withDependent("det|nmod:poss", whWord.andNot(NodePattern.N.directlyBefore(NodePattern.N.form("ever")))).withDependent("acl:relcl")));
    private static final NodePattern beforeComma = NodePattern.N.withPhraseEnd(NodePattern.or(CommonPatterns.comma, NodePattern.N.directlyBefore(CommonPatterns.comma)));
    private static final NodePattern exclamatoryStart = NodePattern.or(NodePattern.N.withHeadRelation("advmod").potentialPos("RB.*").andNot(beforeComma).noForm("so"), NodePattern.N.withHeadRelation("discourse").and(beforeComma));
    private static final NodePattern allowedBeforeWh = NodePattern.or(NodePattern.N.form("and|but|or|so").withHeadRelation("cc"), NodePattern.N.withHeadRelation("discourse|punct"), NodePattern.N.withHeadRelation("advmod").noForm("neither|nor")).noDependents("advcl");
    private static final NodePattern allowedBeforeLeadingVerb = allowedBeforeWh.andNot(exclamatoryStart);
    static final NodePattern semiModalRootQuestion = NodePattern.N.form("need|dare").withDependent("ccomp|xcomp", NodePattern.N.withDependent("nsubj").and(CommonPatterns.possiblySkipDown("cop", NodePattern.N.pos("VBP?")))).noDependents(NodePattern.N.beforeHead().andNot(allowedBeforeLeadingVerb));
    static final NodePattern questionWithOmittedAux = NodePattern.ROOT.and(CommonPatterns.withQuestionMark).withDependent("nsubj(:pass|:outer)?|csubj(:pass)?", NodePattern.N.markAs("Subj").anyPos().andOr(CommonPatterns.firstPhrase.andNot(whPhrase).andNot(CommonPatterns.firstWord.pos("NNP").potentialPos("JJ.*")), NodePattern.N.withPrevSibling(whWord.markAs("Wh")), CommonPatterns.afterSkipping(CommonPatterns.comma, NodePattern.N.withHeadRelation("vocative|discourse")))).noDependents("cop|aux|aux:pass").noDependents("conj", EnglishTreePatterns.clause.afterHead());
    static final NodePattern question = Questions.question();
    static final NodePattern possiblyQuestion = NodePattern.or(question, NodePattern.N.withDependent("punct", NodePattern.N.form(".*\\?.*")), NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.afterHead().markAs("Aux")).anyMatchUntil("Aux", CommonPatterns.colon));

    Questions() {
    }

    private static NodePattern question() {
        NodePattern commaStartingClause = NodePattern.N.markAs("clause").withDependent("punct", CommonPatterns.comma.before("clause"));
        NodePattern misparsedCsubjHead = NodePattern.N.pos("VBZ").noDependents(NodePattern.N.beforeHead().andNot(NodePattern.PUNCT));
        NodePattern argWhQuestion = NodePattern.N.withDependent(".*", whPhrase.markAs("Wh").withPhraseEnd(NodePattern.N.directlyBefore("Verb"))).noDependents(NodePattern.N.before("Wh").andNot(allowedBeforeWh)).noDependents("conj", misparsedCsubjHead);
        NodePattern whAbout = CommonPatterns.possiblySkipDown("nsubj|obj|obl", NodePattern.N.inFormSequence(0, "how|what", "about").noDependents("parataxis", CommonPatterns.phraseStartsWithComma).andNot(CommonPatterns.phraseEndsWithComma));
        NodePattern copulaWhQuestion = whPhrase.before("Verb").withDependent("cop", NodePattern.N.alreadyMarkedAs("Verb"));
        NodePattern leadingVerbQuestion = NodePattern.N.noDependents(NodePattern.N.before("Verb").andNot(allowedBeforeLeadingVerb)).andNot(NodePattern.N.before("Verb").withDependent("cop|aux:pass")).andNot(NodePattern.markedNodeMatches("Verb", EnglishTreePatterns.doSoTypo));
        NodePattern questionWordPossibleCompound = whPhrase.and(CommonPatterns.insideQuotes);
        NodePattern questionClause = EnglishTreePatterns.clause.noHeadRelation("acl:relcl").withDependent("nsubj(:pass|:outer)?|csubj(:pass)?|expl", NodePattern.N.markAs("Subj").noDependents(questionWordPossibleCompound)).and(NodePattern.or(NodePattern.N.withDependent("cop|aux|aux:pass", NodePattern.N.noForm("be").noLemma("get").markAs("Verb")).andNot(NodePattern.N.lemma("be").before("Subj")).andNot(NodePattern.markedNodeMatches("Subj", NodePattern.N.afterHead().withHeadRelation("csubj"))), NodePattern.N.noDependents("cop|aux|aux:pass").withDependent("nsubj", whPhrase.beforeHead()).markAs("Verb"), NodePattern.N.lemma("be").markAs("Verb"))).noDependents("cop|aux|aux:pass", NodePattern.N.between("Verb", "Subj")).unmark("Subj").andOr(argWhQuestion, copulaWhQuestion, leadingVerbQuestion);
        return NodePattern.or(questionClause, whAbout, semiModalRootQuestion).noDependents("obl|obj", NodePattern.N.withDependent("acl:relcl", commaStartingClause)).noDependents("ccomp", NodePattern.or(commaStartingClause.andNot(CommonPatterns.insideQuotes), NodePattern.N.withPhraseStart(NodePattern.N.withHeadRelation("mark").directlyBefore(CommonPatterns.comma)))).andNot(NodePattern.N.withDependent("aux", NodePattern.N.form("would")).withDependent("advmod", NodePattern.N.form("only")));
    }
}

