/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.statistics;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.psi.PsiElement;
import com.intellij.spellchecker.inspections.SpellCheckingInspection;
import com.intellij.spellchecker.tokenizer.SpellcheckingStrategy;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\b\u0010\fJ\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0010\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcom/intellij/spellchecker/statistics/SpellcheckerRateTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "language", "Lcom/intellij/lang/Language;", "domain", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/lang/Language;Ljava/lang/String;)V", "element", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLanguage", "()Lcom/intellij/lang/Language;", "getDomain", "()Ljava/lang/String;", "shown", "Lkotlin/concurrent/atomics/AtomicBoolean;", "Ljava/util/concurrent/atomic/AtomicBoolean;", "markShown", "", "Companion", "intellij.spellchecker"})
public final class SpellcheckerRateTracker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final Language language;
    @NotNull
    private final String domain;
    @NotNull
    private final AtomicBoolean shown;

    private SpellcheckerRateTracker(Project project, Language language, String domain) {
        this.project = project;
        this.language = language;
        this.domain = domain;
        this.shown = new AtomicBoolean(false);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Language getLanguage() {
        return this.language;
    }

    @NotNull
    public final String getDomain() {
        return this.domain;
    }

    public SpellcheckerRateTracker(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Language language = element.getLanguage();
        Intrinsics.checkNotNullExpressionValue((Object)language, (String)"getLanguage(...)");
        this(project, language, SpellcheckerRateTracker.Companion.determineDomain(element));
    }

    public final boolean markShown() {
        return this.shown.compareAndSet(false, true);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\b"}, d2={"Lcom/intellij/spellchecker/statistics/SpellcheckerRateTracker$Companion;", "", "<init>", "()V", "determineDomain", "", "element", "Lcom/intellij/psi/PsiElement;", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        private final String determineDomain(PsiElement element) {
            SpellcheckingStrategy strategy = SpellcheckingStrategy.getSpellcheckingStrategy(element);
            if (CommitMessage.isCommitMessage((PsiElement)element)) {
                return "commit";
            }
            if (strategy.elementFitsScope(element, SetsKt.setOf((Object)((Object)SpellCheckingInspection.SpellCheckingScope.Literals)))) {
                return "literal";
            }
            if (strategy.elementFitsScope(element, SetsKt.setOf((Object)((Object)SpellCheckingInspection.SpellCheckingScope.Comments)))) {
                return "comment";
            }
            return "code";
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

