/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.share;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.kafka.common.message.InitializeShareGroupStateRequestData;
import org.apache.kafka.common.message.WriteShareGroupStateRequestData;
import org.apache.kafka.coordinator.share.generated.ShareSnapshotValue;
import org.apache.kafka.coordinator.share.generated.ShareUpdateValue;
import org.apache.kafka.server.share.persister.PersisterStateBatch;

public class ShareGroupOffset {
    public static final int NO_TIMESTAMP = 0;
    public static final int UNINITIALIZED_EPOCH = 0;
    public static final int UNINITIALIZED_DELIVERY_COMPLETE_COUNT = -1;
    public static final int DEFAULT_EPOCH = 0;
    private final int snapshotEpoch;
    private final int stateEpoch;
    private final int leaderEpoch;
    private final long startOffset;
    private final int deliveryCompleteCount;
    private final List<PersisterStateBatch> stateBatches;
    private final long createTimestamp;
    private final long writeTimestamp;

    private ShareGroupOffset(int snapshotEpoch, int stateEpoch, int leaderEpoch, long startOffset, int deliveryCompleteCount, List<PersisterStateBatch> stateBatches, long createTimestamp, long writeTimestamp) {
        this.snapshotEpoch = snapshotEpoch;
        this.stateEpoch = stateEpoch;
        this.leaderEpoch = leaderEpoch;
        this.startOffset = startOffset;
        this.deliveryCompleteCount = deliveryCompleteCount;
        this.stateBatches = stateBatches;
        this.createTimestamp = createTimestamp;
        this.writeTimestamp = writeTimestamp;
    }

    public int snapshotEpoch() {
        return this.snapshotEpoch;
    }

    public int stateEpoch() {
        return this.stateEpoch;
    }

    public int leaderEpoch() {
        return this.leaderEpoch;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public int deliveryCompleteCount() {
        return this.deliveryCompleteCount;
    }

    public long createTimestamp() {
        return this.createTimestamp;
    }

    public long writeTimestamp() {
        return this.writeTimestamp;
    }

    public List<PersisterStateBatch> stateBatches() {
        return Collections.unmodifiableList(this.stateBatches);
    }

    private static PersisterStateBatch toPersisterOffsetsStateBatch(ShareSnapshotValue.StateBatch stateBatch) {
        return new PersisterStateBatch(stateBatch.firstOffset(), stateBatch.lastOffset(), stateBatch.deliveryState(), stateBatch.deliveryCount());
    }

    private static PersisterStateBatch toPersisterOffsetsStateBatch(ShareUpdateValue.StateBatch stateBatch) {
        return new PersisterStateBatch(stateBatch.firstOffset(), stateBatch.lastOffset(), stateBatch.deliveryState(), stateBatch.deliveryCount());
    }

    public static ShareGroupOffset fromRecord(ShareSnapshotValue record) {
        return new ShareGroupOffset(record.snapshotEpoch(), record.stateEpoch(), record.leaderEpoch(), record.startOffset(), record.deliveryCompleteCount(), record.stateBatches().stream().map(ShareGroupOffset::toPersisterOffsetsStateBatch).toList(), record.createTimestamp(), record.writeTimestamp());
    }

    public static ShareGroupOffset fromRecord(ShareUpdateValue record) {
        return new ShareGroupOffset(record.snapshotEpoch(), 0, record.leaderEpoch(), record.startOffset(), record.deliveryCompleteCount(), record.stateBatches().stream().map(ShareGroupOffset::toPersisterOffsetsStateBatch).toList(), 0L, 0L);
    }

    public static ShareGroupOffset fromRequest(WriteShareGroupStateRequestData.PartitionData data, long timestamp) {
        return ShareGroupOffset.fromRequest(data, 0, timestamp);
    }

    public static ShareGroupOffset fromRequest(WriteShareGroupStateRequestData.PartitionData data, int snapshotEpoch, long timestamp) {
        return new ShareGroupOffset(snapshotEpoch, data.stateEpoch(), data.leaderEpoch(), data.startOffset(), data.deliveryCompleteCount(), data.stateBatches().stream().map(PersisterStateBatch::from).toList(), timestamp, timestamp);
    }

    public static ShareGroupOffset fromRequest(InitializeShareGroupStateRequestData.PartitionData data, long timestamp) {
        return ShareGroupOffset.fromRequest(data, 0, timestamp);
    }

    public static ShareGroupOffset fromRequest(InitializeShareGroupStateRequestData.PartitionData data, int snapshotEpoch, long timestamp) {
        return new ShareGroupOffset(snapshotEpoch, data.stateEpoch(), 0, data.startOffset(), -1, List.of(), timestamp, timestamp);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShareGroupOffset that = (ShareGroupOffset)o;
        return this.snapshotEpoch == that.snapshotEpoch && this.stateEpoch == that.stateEpoch && this.leaderEpoch == that.leaderEpoch && this.startOffset == that.startOffset && this.deliveryCompleteCount == that.deliveryCompleteCount && Objects.equals(this.stateBatches, that.stateBatches) && this.createTimestamp == that.createTimestamp && this.writeTimestamp == that.writeTimestamp;
    }

    public int hashCode() {
        return Objects.hash(this.snapshotEpoch, this.stateEpoch, this.leaderEpoch, this.startOffset, this.deliveryCompleteCount, this.stateBatches, this.createTimestamp, this.writeTimestamp);
    }

    public String toString() {
        return "ShareGroupOffset{snapshotEpoch=" + this.snapshotEpoch + ", stateEpoch=" + this.stateEpoch + ", leaderEpoch=" + this.leaderEpoch + ", startOffset=" + this.startOffset + ", deliveryCompleteCount=" + this.deliveryCompleteCount + ", createTimestamp=" + this.createTimestamp + ", writeTimestamp=" + this.writeTimestamp + ", stateBatches=" + String.valueOf(this.stateBatches) + "}";
    }

    public Builder builderSupplier() {
        return new Builder().setSnapshotEpoch(this.snapshotEpoch()).setStateEpoch(this.stateEpoch()).setLeaderEpoch(this.leaderEpoch()).setStartOffset(this.startOffset()).setDeliveryCompleteCount(this.deliveryCompleteCount()).setStateBatches(this.stateBatches()).setCreateTimestamp(this.createTimestamp()).setWriteTimestamp(this.writeTimestamp());
    }

    public static class Builder {
        private int snapshotEpoch;
        private int stateEpoch;
        private int leaderEpoch;
        private long startOffset;
        private int deliveryCompleteCount;
        private List<PersisterStateBatch> stateBatches;
        private long createTimestamp = 0L;
        private long writeTimestamp = 0L;

        public Builder setSnapshotEpoch(int snapshotEpoch) {
            this.snapshotEpoch = snapshotEpoch;
            return this;
        }

        public Builder setStateEpoch(int stateEpoch) {
            this.stateEpoch = stateEpoch;
            return this;
        }

        public Builder setLeaderEpoch(int leaderEpoch) {
            this.leaderEpoch = leaderEpoch;
            return this;
        }

        public Builder setStartOffset(long startOffset) {
            this.startOffset = startOffset;
            return this;
        }

        public Builder setDeliveryCompleteCount(int deliveryCompleteCount) {
            this.deliveryCompleteCount = deliveryCompleteCount;
            return this;
        }

        public Builder setStateBatches(List<PersisterStateBatch> stateBatches) {
            this.stateBatches = stateBatches == null ? List.of() : stateBatches.stream().toList();
            return this;
        }

        public Builder setCreateTimestamp(long createTimestamp) {
            this.createTimestamp = createTimestamp;
            return this;
        }

        public Builder setWriteTimestamp(long writeTimestamp) {
            this.writeTimestamp = writeTimestamp;
            return this;
        }

        public ShareGroupOffset build() {
            return new ShareGroupOffset(this.snapshotEpoch, this.stateEpoch, this.leaderEpoch, this.startOffset, this.deliveryCompleteCount, this.stateBatches, this.createTimestamp, this.writeTimestamp);
        }
    }
}

