﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/elasticache/ElastiCacheRequest.h>
#include <aws/elasticache/ElastiCache_EXPORTS.h>

#include <utility>

namespace Aws {
namespace ElastiCache {
namespace Model {

/**
 */
class FailoverGlobalReplicationGroupRequest : public ElastiCacheRequest {
 public:
  AWS_ELASTICACHE_API FailoverGlobalReplicationGroupRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "FailoverGlobalReplicationGroup"; }

  AWS_ELASTICACHE_API Aws::String SerializePayload() const override;

 protected:
  AWS_ELASTICACHE_API void DumpBodyToUrl(Aws::Http::URI& uri) const override;

 public:
  ///@{
  /**
   * <p>The name of the Global datastore</p>
   */
  inline const Aws::String& GetGlobalReplicationGroupId() const { return m_globalReplicationGroupId; }
  inline bool GlobalReplicationGroupIdHasBeenSet() const { return m_globalReplicationGroupIdHasBeenSet; }
  template <typename GlobalReplicationGroupIdT = Aws::String>
  void SetGlobalReplicationGroupId(GlobalReplicationGroupIdT&& value) {
    m_globalReplicationGroupIdHasBeenSet = true;
    m_globalReplicationGroupId = std::forward<GlobalReplicationGroupIdT>(value);
  }
  template <typename GlobalReplicationGroupIdT = Aws::String>
  FailoverGlobalReplicationGroupRequest& WithGlobalReplicationGroupId(GlobalReplicationGroupIdT&& value) {
    SetGlobalReplicationGroupId(std::forward<GlobalReplicationGroupIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon region of the primary cluster of the Global datastore</p>
   */
  inline const Aws::String& GetPrimaryRegion() const { return m_primaryRegion; }
  inline bool PrimaryRegionHasBeenSet() const { return m_primaryRegionHasBeenSet; }
  template <typename PrimaryRegionT = Aws::String>
  void SetPrimaryRegion(PrimaryRegionT&& value) {
    m_primaryRegionHasBeenSet = true;
    m_primaryRegion = std::forward<PrimaryRegionT>(value);
  }
  template <typename PrimaryRegionT = Aws::String>
  FailoverGlobalReplicationGroupRequest& WithPrimaryRegion(PrimaryRegionT&& value) {
    SetPrimaryRegion(std::forward<PrimaryRegionT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the primary replication group</p>
   */
  inline const Aws::String& GetPrimaryReplicationGroupId() const { return m_primaryReplicationGroupId; }
  inline bool PrimaryReplicationGroupIdHasBeenSet() const { return m_primaryReplicationGroupIdHasBeenSet; }
  template <typename PrimaryReplicationGroupIdT = Aws::String>
  void SetPrimaryReplicationGroupId(PrimaryReplicationGroupIdT&& value) {
    m_primaryReplicationGroupIdHasBeenSet = true;
    m_primaryReplicationGroupId = std::forward<PrimaryReplicationGroupIdT>(value);
  }
  template <typename PrimaryReplicationGroupIdT = Aws::String>
  FailoverGlobalReplicationGroupRequest& WithPrimaryReplicationGroupId(PrimaryReplicationGroupIdT&& value) {
    SetPrimaryReplicationGroupId(std::forward<PrimaryReplicationGroupIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_globalReplicationGroupId;
  bool m_globalReplicationGroupIdHasBeenSet = false;

  Aws::String m_primaryRegion;
  bool m_primaryRegionHasBeenSet = false;

  Aws::String m_primaryReplicationGroupId;
  bool m_primaryReplicationGroupIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace ElastiCache
}  // namespace Aws
