﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/sagemaker/SageMaker_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace SageMaker {
namespace Model {
class CreateInferenceComponentResult {
 public:
  AWS_SAGEMAKER_API CreateInferenceComponentResult() = default;
  AWS_SAGEMAKER_API CreateInferenceComponentResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_SAGEMAKER_API CreateInferenceComponentResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the inference component.</p>
   */
  inline const Aws::String& GetInferenceComponentArn() const { return m_inferenceComponentArn; }
  template <typename InferenceComponentArnT = Aws::String>
  void SetInferenceComponentArn(InferenceComponentArnT&& value) {
    m_inferenceComponentArnHasBeenSet = true;
    m_inferenceComponentArn = std::forward<InferenceComponentArnT>(value);
  }
  template <typename InferenceComponentArnT = Aws::String>
  CreateInferenceComponentResult& WithInferenceComponentArn(InferenceComponentArnT&& value) {
    SetInferenceComponentArn(std::forward<InferenceComponentArnT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  CreateInferenceComponentResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_inferenceComponentArn;

  Aws::String m_requestId;
  bool m_inferenceComponentArnHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace SageMaker
}  // namespace Aws
