/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.correlate;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.block.BasicBlockModel;
import ghidra.program.model.block.CodeBlock;
import ghidra.program.model.block.CodeBlockIterator;
import ghidra.program.model.correlate.Block;
import ghidra.program.model.correlate.Hash;
import ghidra.program.model.correlate.HashCalculator;
import ghidra.program.model.correlate.HashEntry;
import ghidra.program.model.correlate.InstructHash;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;

public class HashStore {
    private Program program;
    private Function function;
    private TaskMonitor monitor;
    private TreeMap<Address, Block> blockList;
    private TreeMap<Hash, HashEntry> hashSort;
    private TreeSet<HashEntry> matchSort;
    private int matchedBlockCount;
    private int matchedInstructionCount;
    private int totalInstructions;

    public HashStore(Function a, TaskMonitor mon) throws CancelledException {
        this.function = a;
        this.program = a.getProgram();
        this.monitor = mon;
        this.blockList = new TreeMap();
        this.hashSort = new TreeMap();
        this.matchSort = new TreeSet<HashEntry>(new HashOrderComparator());
        this.matchedBlockCount = 0;
        this.matchedInstructionCount = 0;
        this.totalInstructions = 0;
        this.initializeStructures();
    }

    public int getTotalInstructions() {
        return this.totalInstructions;
    }

    public int numMatchedInstructions() {
        return this.matchedInstructionCount;
    }

    private void initializeStructures() throws CancelledException {
        BasicBlockModel blockModel = new BasicBlockModel(this.program);
        CodeBlockIterator iter = blockModel.getCodeBlocksContaining(this.function.getBody(), this.monitor);
        while (iter.hasNext()) {
            CodeBlock block = iter.next();
            this.createBlock(block);
        }
    }

    private void createBlock(CodeBlock codeBlock) {
        Block res = new Block(codeBlock);
        ArrayList<InstructHash> instList = new ArrayList<InstructHash>();
        Listing listing = this.program.getListing();
        Iterator<AddressRange> iter = codeBlock.iterator(true);
        int index = 0;
        while (iter.hasNext()) {
            AddressRange range = iter.next();
            Address cur = range.getMinAddress();
            Address max = range.getMaxAddress();
            while (cur.compareTo(max) <= 0) {
                Instruction instruct = listing.getInstructionAt(cur);
                if (instruct != null) {
                    InstructHash instHash = new InstructHash(instruct, res, index);
                    instList.add(instHash);
                    ++index;
                    ++this.totalInstructions;
                    cur = cur.add(instruct.getLength());
                    continue;
                }
                cur = cur.next();
            }
        }
        res.instList = new InstructHash[instList.size()];
        instList.toArray(res.instList);
        this.blockList.put(codeBlock.getFirstStartAddress(), res);
    }

    private void insertNGram(Hash curHash, InstructHash instHash) {
        HashEntry entry = this.hashSort.get(curHash);
        if (entry == null) {
            entry = new HashEntry(curHash);
            this.hashSort.put(curHash, entry);
        } else {
            this.matchSort.remove(entry);
        }
        entry.instList.add(instHash);
        instHash.hashEntries.put(curHash, entry);
        this.matchSort.add(entry);
    }

    private void insertInstructionNGrams(InstructHash instHash) {
        Hash curHash;
        for (int i = 0; i < instHash.nGrams.length && (curHash = instHash.nGrams[i]) != null; ++i) {
            this.insertNGram(curHash, instHash);
        }
    }

    private void removeNGram(InstructHash instHash, Hash curHash) {
        HashEntry hashEntry = instHash.hashEntries.remove(curHash);
        this.matchSort.remove(hashEntry);
        hashEntry.instList.remove(instHash);
        if (hashEntry.instList.isEmpty()) {
            this.hashSort.remove(curHash);
        } else {
            this.matchSort.add(hashEntry);
        }
    }

    private void removeInstructionNGrams(InstructHash instHash) {
        for (int i = 0; i < instHash.nGrams.length; ++i) {
            HashEntry hashEntry;
            Hash curHash = instHash.nGrams[i];
            if (curHash == null || (hashEntry = instHash.hashEntries.get(curHash)) == null) continue;
            this.matchSort.remove(hashEntry);
            hashEntry.instList.remove(instHash);
            if (hashEntry.instList.isEmpty()) {
                this.hashSort.remove(curHash);
                continue;
            }
            this.matchSort.add(hashEntry);
        }
    }

    public void removeHash(HashEntry hashEntry) {
        this.matchSort.remove(hashEntry);
        this.hashSort.remove(hashEntry.hash);
        for (InstructHash instruct : hashEntry.instList) {
            instruct.hashEntries.remove(hashEntry.hash);
        }
    }

    public void calcHashes(int minLength, int maxLength, boolean wholeBlock, boolean matchOnly, HashCalculator hashCalc) throws MemoryAccessException {
        for (Block block : this.blockList.values()) {
            block.calcHashes(minLength, maxLength, wholeBlock, matchOnly, hashCalc);
        }
    }

    public void insertHashes() {
        for (Block block : this.blockList.values()) {
            for (int j = 0; j < block.instList.length; ++j) {
                InstructHash instruct = block.instList[j];
                if (instruct.isMatched) continue;
                this.insertInstructionNGrams(instruct);
            }
        }
    }

    public void matchHash(NgramMatch match, List<Instruction> instResult, List<CodeBlock> blockResult) {
        InstructHash curInstruct;
        Block block = match.block;
        for (int index = match.startindex; index <= match.endindex; ++index) {
            curInstruct = block.instList[index];
            instResult.add(curInstruct.instruction);
            ++this.matchedInstructionCount;
            curInstruct.isMatched = true;
            this.removeInstructionNGrams(curInstruct);
            curInstruct.nGrams = null;
        }
        if (block.isMatched) {
            return;
        }
        ++this.matchedBlockCount;
        block.setMatched(this.matchedBlockCount);
        blockResult.add(block.origBlock);
        for (int i = 0; i < block.instList.length; ++i) {
            curInstruct = block.instList[i];
            if (curInstruct.isMatched) continue;
            for (int j = 0; j < curInstruct.nGrams.length; ++j) {
                HashEntry curEntry;
                Hash curHash = curInstruct.nGrams[j];
                if (curHash == null || (curEntry = curInstruct.hashEntries.get(curHash)) == null) continue;
                this.removeNGram(curInstruct, curHash);
                int newValue = curHash.value ^ block.getMatchHash();
                curInstruct.nGrams[j] = curHash = new Hash(newValue, curHash.size);
                this.insertNGram(curHash, curInstruct);
            }
        }
    }

    public static void extendMatch(int nGramSize, InstructHash srcInstruct, NgramMatch srcMatch, InstructHash destInstruct, NgramMatch destMatch, HashCalculator hashCalc) throws MemoryAccessException {
        srcMatch.block = srcInstruct.block;
        srcMatch.startindex = srcInstruct.index;
        srcMatch.endindex = srcMatch.startindex + nGramSize - 1;
        destMatch.block = destInstruct.block;
        destMatch.startindex = destInstruct.index;
        destMatch.endindex = destMatch.startindex + nGramSize - 1;
        while (srcMatch.startindex > 0 && destMatch.startindex > 0) {
            InstructHash curSrcInstruct = srcMatch.block.instList[srcMatch.startindex - 1];
            InstructHash curDestInstruct = destMatch.block.instList[destMatch.startindex - 1];
            if (curSrcInstruct.isMatched || curDestInstruct.isMatched) break;
            int srcVal = 11111;
            int destVal = 11111;
            if ((srcVal = hashCalc.calcHash(srcVal, curSrcInstruct.instruction)) != (destVal = hashCalc.calcHash(destVal, curDestInstruct.instruction))) break;
            --srcMatch.startindex;
            --destMatch.startindex;
        }
        int srcMax = srcMatch.block.instList.length - 1;
        int destMax = destMatch.block.instList.length - 1;
        while (srcMatch.endindex < srcMax && destMatch.endindex < destMax) {
            InstructHash curSrcInstruct = srcMatch.block.instList[srcMatch.endindex + 1];
            InstructHash curDestInstruct = destMatch.block.instList[destMatch.endindex + 1];
            if (curSrcInstruct.isMatched || curDestInstruct.isMatched) break;
            int srcVal = 11111;
            int destVal = 11111;
            if ((srcVal = hashCalc.calcHash(srcVal, curSrcInstruct.instruction)) != (destVal = hashCalc.calcHash(destVal, curDestInstruct.instruction))) break;
            ++srcMatch.endindex;
            ++destMatch.endindex;
        }
    }

    public List<Instruction> getUnmatchedInstructions() {
        LinkedList<Instruction> res = new LinkedList<Instruction>();
        for (Block block : this.blockList.values()) {
            for (InstructHash instHash : block.instList) {
                if (instHash.isMatched) continue;
                res.add(instHash.instruction);
            }
        }
        return res;
    }

    public void clearSort() {
        this.hashSort.clear();
        this.matchSort.clear();
        for (Block block : this.blockList.values()) {
            block.clearSort();
        }
    }

    public boolean isEmpty() {
        return this.matchSort.isEmpty();
    }

    public HashEntry getFirstEntry() {
        return this.matchSort.first();
    }

    public HashEntry getEntry(Hash hash) {
        return this.hashSort.get(hash);
    }

    public Block getBlock(Address addr) {
        return this.blockList.get(addr);
    }

    public TaskMonitor getMonitor() {
        return this.monitor;
    }

    private static class HashOrderComparator
    implements Comparator<HashEntry> {
        private HashOrderComparator() {
        }

        @Override
        public int compare(HashEntry o1, HashEntry o2) {
            int sz2;
            int sz1 = o1.instList.size();
            if (sz1 != (sz2 = o2.instList.size())) {
                return sz1 < sz2 ? -1 : 1;
            }
            if (o1.hash.size != o2.hash.size) {
                return o1.hash.size > o2.hash.size ? -1 : 1;
            }
            return Long.compare(o1.hash.value, o2.hash.value);
        }
    }

    public static class NgramMatch {
        public Block block;
        public int startindex;
        public int endindex;
    }
}

