/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.pcode.floatformat.BigFloat;
import ghidra.pcode.floatformat.FloatFormat;
import ghidra.pcode.floatformat.FloatFormatFactory;
import ghidra.pcode.floatformat.UnsupportedFloatFormatException;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.data.BuiltIn;
import ghidra.program.model.data.DataOrganization;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeEncodeException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.DefaultDataType;
import ghidra.program.model.data.DoubleDataType;
import ghidra.program.model.data.Float10DataType;
import ghidra.program.model.data.Float16DataType;
import ghidra.program.model.data.Float2DataType;
import ghidra.program.model.data.Float4DataType;
import ghidra.program.model.data.Float8DataType;
import ghidra.program.model.data.FloatDataType;
import ghidra.program.model.data.LongDoubleDataType;
import ghidra.program.model.data.Undefined;
import ghidra.program.model.mem.MemBuffer;
import java.math.BigInteger;
import java.util.TreeMap;

public abstract class AbstractFloatDataType
extends BuiltIn {
    private static SettingsDefinition[] SETTINGS_DEFS = new SettingsDefinition[0];
    private final FloatFormat floatFormat;
    private final int encodedLength;
    private String description;
    private static TreeMap<Integer, AbstractFloatDataType> floatTypes;

    public AbstractFloatDataType(String name, int encodedLength, DataTypeManager dtm) {
        super(null, name, dtm);
        if (encodedLength < 1) {
            throw new IllegalArgumentException("Invalid encoded length: " + encodedLength);
        }
        this.encodedLength = encodedLength;
        FloatFormat format = null;
        try {
            format = FloatFormatFactory.getFloatFormat(this.getLength());
        }
        catch (UnsupportedFloatFormatException unsupportedFloatFormatException) {
            // empty catch block
        }
        this.floatFormat = format;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return this.name;
    }

    protected final String buildIEEE754StandardDescription() {
        StringBuilder buf = new StringBuilder("IEEE 754 floating-point type (");
        int bitLen = this.encodedLength * 8;
        buf.append(Integer.toString(bitLen));
        buf.append("-bit / ");
        buf.append(Integer.toString(this.encodedLength));
        buf.append("-byte format, aligned-length is ");
        buf.append(Integer.toString(this.getAlignedLength()));
        buf.append("-bytes)");
        return buf.toString();
    }

    protected String buildDescription() {
        return this.buildIEEE754StandardDescription();
    }

    @Override
    public final String getDescription() {
        if (this.description == null) {
            this.description = this.buildDescription();
        }
        return this.description;
    }

    @Override
    public Class<?> getValueClass(Settings settings) {
        return BigFloat.class;
    }

    @Override
    public final int getLength() {
        return this.encodedLength;
    }

    @Override
    public BigFloat getValue(MemBuffer buf, Settings settings, int length) {
        try {
            int len = this.getLength();
            if (this.floatFormat == null) {
                return null;
            }
            byte[] bytes = new byte[len];
            if (buf.getBytes(bytes, 0) != len) {
                return null;
            }
            if (len <= 8) {
                long value = Utils.bytesToLong(bytes, len, buf.isBigEndian());
                return this.floatFormat.decodeBigFloat(value);
            }
            BigInteger value = Utils.bytesToBigInteger(bytes, len, buf.isBigEndian(), false);
            return this.floatFormat.decodeBigFloat(value);
        }
        catch (UnsupportedFloatFormatException e) {
            return null;
        }
    }

    @Override
    public boolean isEncodable() {
        return this.floatFormat != null;
    }

    @Override
    public byte[] encodeValue(Object value, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        try {
            int len = this.getLength();
            if (this.floatFormat == null) {
                throw new DataTypeEncodeException("Unsupported float format (" + len + " bytes)", value, this);
            }
            if ((len == 8 || len == 4) && value instanceof Number) {
                double doubleValue = ((Number)value).doubleValue();
                long encoding = this.floatFormat.getEncoding(doubleValue);
                return Utils.longToBytes(encoding, len, buf.isBigEndian());
            }
            if (!(value instanceof BigFloat)) {
                throw new DataTypeEncodeException("non-standard float length requires BigFloat type", value, this);
            }
            BigInteger encoding = this.floatFormat.getEncoding((BigFloat)value);
            return Utils.bigIntegerToBytes(encoding, len, buf.isBigEndian());
        }
        catch (DataTypeEncodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeEncodeException(value, this, e);
        }
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        BigFloat value = this.getValue(buf, settings, length);
        if (value == null) {
            return "??";
        }
        return this.floatFormat != null ? this.floatFormat.toDecimalString(value, true) : value.toString();
    }

    @Override
    public byte[] encodeRepresentation(String repr, MemBuffer buf, Settings settings, int length) throws DataTypeEncodeException {
        try {
            int len = this.getLength();
            if (this.floatFormat == null) {
                throw new DataTypeEncodeException("Unsupported float format (" + len + " bytes)", repr, this);
            }
            if (length == 8 || length == 4) {
                double doubleValue = Double.parseDouble(repr);
                return this.encodeValue(doubleValue, buf, settings, length);
            }
            BigFloat bf = this.floatFormat.getBigFloat(repr);
            this.floatFormat.round(bf);
            return this.encodeValue(bf, buf, settings, length);
        }
        catch (DataTypeEncodeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DataTypeEncodeException((Object)repr, this, e);
        }
    }

    @Override
    protected SettingsDefinition[] getBuiltInSettingsDefinitions() {
        return SETTINGS_DEFS;
    }

    @Override
    public String getDefaultLabelPrefix() {
        return this.name.toUpperCase();
    }

    @Override
    public String getCTypeDeclaration(DataOrganization dataOrganization) {
        return this.hasLanguageDependantLength() ? null : this.name;
    }

    private static synchronized TreeMap<Integer, AbstractFloatDataType> getFloatTypes() {
        if (floatTypes == null) {
            floatTypes = new TreeMap();
            floatTypes.put(Float2DataType.dataType.getLength(), Float2DataType.dataType);
            floatTypes.put(Float4DataType.dataType.getLength(), Float4DataType.dataType);
            floatTypes.put(Float8DataType.dataType.getLength(), Float8DataType.dataType);
            floatTypes.put(Float10DataType.dataType.getLength(), Float10DataType.dataType);
            floatTypes.put(Float16DataType.dataType.getLength(), Float16DataType.dataType);
        }
        return floatTypes;
    }

    public static DataType getFloatDataType(int rawFormatByteSize, DataTypeManager dtm) {
        DataType dt;
        DataOrganization dataOrganization;
        if (rawFormatByteSize < 1) {
            return DefaultDataType.dataType;
        }
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            if (rawFormatByteSize == dataOrganization.getFloatSize()) {
                return FloatDataType.dataType.clone(dtm);
            }
            if (rawFormatByteSize == dataOrganization.getDoubleSize()) {
                return DoubleDataType.dataType.clone(dtm);
            }
            if (rawFormatByteSize == dataOrganization.getLongDoubleSize()) {
                return LongDoubleDataType.dataType.clone(dtm);
            }
        }
        if ((dt = (DataType)AbstractFloatDataType.getFloatTypes().get(rawFormatByteSize)) == null) {
            return Undefined.getUndefinedDataType(rawFormatByteSize);
        }
        return dt;
    }

    public static AbstractFloatDataType[] getFloatDataTypes(DataTypeManager dtm) {
        DataOrganization dataOrganization;
        TreeMap<Integer, AbstractFloatDataType> floatMap = AbstractFloatDataType.getFloatTypes();
        TreeMap<Integer, AbstractFloatDataType> newFloatMap = floatMap;
        if (dtm != null && (dataOrganization = dtm.getDataOrganization()) != null) {
            newFloatMap = new TreeMap();
            newFloatMap.put(dataOrganization.getFloatSize(), (AbstractFloatDataType)FloatDataType.dataType.clone(dtm));
            if (!newFloatMap.containsKey(dataOrganization.getDoubleSize())) {
                newFloatMap.put(dataOrganization.getDoubleSize(), (AbstractFloatDataType)DoubleDataType.dataType.clone(dtm));
            }
            if (!newFloatMap.containsKey(dataOrganization.getLongDoubleSize())) {
                newFloatMap.put(dataOrganization.getLongDoubleSize(), (AbstractFloatDataType)LongDoubleDataType.dataType.clone(dtm));
            }
            for (int size : floatMap.keySet()) {
                if (newFloatMap.containsKey(size)) continue;
                newFloatMap.put(size, (AbstractFloatDataType)floatMap.get(size).clone(dtm));
            }
        }
        AbstractFloatDataType[] floatTypeArray = new AbstractFloatDataType[newFloatMap.size()];
        newFloatMap.values().toArray(floatTypeArray);
        return floatTypeArray;
    }
}

