/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.fieldpanel.support.ViewerPosition;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompileResults;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.util.ProgramLocation;
import java.io.File;

public class DecompileData {
    private final Program program;
    private final Function function;
    private final ProgramLocation location;
    private final DecompileResults decompileResults;
    private final File debugFile;
    private final String message;
    private final ViewerPosition viewerPosition;

    public DecompileData(Program program, Function function, ProgramLocation location, DecompileResults decompileResults, String errorMessage, File debugFile, ViewerPosition viewerPosition) {
        this.program = program;
        this.function = function;
        this.location = location;
        this.decompileResults = decompileResults;
        this.message = errorMessage;
        this.debugFile = debugFile;
        this.viewerPosition = viewerPosition;
    }

    public boolean hasDecompileResults() {
        if (this.decompileResults == null) {
            return false;
        }
        return this.decompileResults.getCCodeMarkup() != null;
    }

    public boolean isValid() {
        return this.decompileResults != null && this.decompileResults.isValid();
    }

    public DecompileResults getDecompileResults() {
        return this.decompileResults;
    }

    public Program getProgram() {
        return this.program;
    }

    public Function getFunction() {
        return this.function;
    }

    public HighFunction getHighFunction() {
        if (this.decompileResults != null) {
            return this.decompileResults.getHighFunction();
        }
        return null;
    }

    public ProgramLocation getLocation() {
        return this.location;
    }

    public ClangTokenGroup getCCodeMarkup() {
        if (this.decompileResults == null) {
            return null;
        }
        return this.decompileResults.getCCodeMarkup();
    }

    public String getErrorMessage() {
        String err;
        if (this.message != null) {
            return this.message;
        }
        if (this.function == null) {
            return "No Function";
        }
        if (this.decompileResults != null && (err = this.decompileResults.getErrorMessage()) != null) {
            return err;
        }
        return "Unknown Error";
    }

    public File getDebugFile() {
        return this.debugFile;
    }

    public boolean contains(ProgramLocation programLocation) {
        if (!this.hasDecompileResults()) {
            return false;
        }
        if (programLocation.getProgram() != this.getProgram()) {
            return false;
        }
        Address address = programLocation.getAddress();
        if (address == null) {
            return false;
        }
        return this.function.getBody().contains(address);
    }

    public AddressSpace getFunctionSpace() {
        return this.function.getEntryPoint().getAddressSpace();
    }

    public ViewerPosition getViewerPosition() {
        return this.viewerPosition;
    }
}

