/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ipfilter;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.ipfilter.IpFilterListener;
import io.netty.handler.ipfilter.IpFilteringHandler;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;

public abstract class IpFilteringHandlerImpl
extends ChannelInboundHandlerAdapter
implements IpFilteringHandler {
    private static final AttributeKey<Object> BLOCKED = AttributeKey.valueOf((String)"BLOCKED");
    private IpFilterListener listener = null;

    protected abstract boolean accept(ChannelHandlerContext var1, InetSocketAddress var2) throws Exception;

    protected ChannelFuture handleRefusedChannel(ChannelHandlerContext ctx, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        ChannelFuture result = this.listener.refused(ctx, inetSocketAddress);
        return result;
    }

    protected ChannelFuture handleAllowedChannel(ChannelHandlerContext ctx, InetSocketAddress inetSocketAddress) throws Exception {
        if (this.listener == null) {
            return null;
        }
        ChannelFuture result = this.listener.allowed(ctx, inetSocketAddress);
        return result;
    }

    protected boolean isBlocked(ChannelHandlerContext ctx) {
        return ctx.attr(BLOCKED).get() != null;
    }

    protected boolean continues(ChannelHandlerContext ctx) throws Exception {
        if (this.listener != null) {
            return this.listener.continues(ctx);
        }
        return false;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (this.isBlocked(ctx) && !this.continues(ctx)) {
            return;
        }
        ctx.fireChannelRegistered();
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        InetSocketAddress inetSocketAddress = (InetSocketAddress)ctx.channel().remoteAddress();
        if (!this.accept(ctx, inetSocketAddress)) {
            ctx.attr(BLOCKED).set((Object)true);
            final ChannelFuture future1 = this.handleRefusedChannel(ctx, inetSocketAddress);
            if (future1 != null) {
                future1.addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

                    public void operationComplete(Future<? super Void> future) throws Exception {
                        future1.channel().close();
                    }
                });
            } else {
                ctx.channel().close();
            }
            if (this.isBlocked(ctx) && !this.continues(ctx)) {
                return;
            }
        } else {
            this.handleAllowedChannel(ctx, inetSocketAddress);
        }
        ctx.attr(BLOCKED).remove();
        ctx.fireChannelActive();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.isBlocked(ctx) && !this.continues(ctx)) {
            return;
        }
        ctx.fireChannelInactive();
    }

    @Override
    public void setIpFilterListener(IpFilterListener listener) {
        this.listener = listener;
    }

    @Override
    public void removeIpFilterListener() {
        this.listener = null;
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.fireChannelReadComplete();
    }
}

