/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.gui;

import docking.widgets.table.AbstractDynamicTableColumn;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableCellRenderingData;
import docking.widgets.table.TableColumnDescriptor;
import generic.theme.Gui;
import ghidra.bitpatterns.gui.FunctionBitPatternsExplorerPlugin;
import ghidra.bitpatterns.info.PatternEvalRowObject;
import ghidra.bitpatterns.info.PatternMatchType;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.datastruct.Accumulator;
import ghidra.util.exception.CancelledException;
import ghidra.util.table.AddressBasedTableModel;
import ghidra.util.table.column.AbstractGColumnRenderer;
import ghidra.util.table.column.GColumnRenderer;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.List;

public class PatternEvalTabelModel
extends AddressBasedTableModel<PatternEvalRowObject> {
    protected static final String FONT_ID = "font.bytepatterns.table";
    private List<PatternEvalRowObject> rowObjects;
    protected final GColumnRenderer<String> monospacedRenderer = new AbstractGColumnRenderer<String>(){

        public Component getTableCellRendererComponent(GTableCellRenderingData data) {
            Component component = super.getTableCellRendererComponent(data);
            component.setFont(Gui.getFont((String)PatternEvalTabelModel.FONT_ID));
            return component;
        }

        public String getFilterString(String t, Settings settings) {
            return t;
        }
    };

    public PatternEvalTabelModel(FunctionBitPatternsExplorerPlugin plugin, Program program, List<PatternEvalRowObject> rowObjects) {
        super("Pattern Evaluation", (ServiceProvider)plugin.getTool(), program, null);
        this.rowObjects = rowObjects;
    }

    public Address getAddress(int row) {
        PatternEvalRowObject rowObject = (PatternEvalRowObject)this.getRowObject(row);
        return rowObject.getMatchedAddress();
    }

    protected TableColumnDescriptor<PatternEvalRowObject> createTableColumnDescriptor() {
        TableColumnDescriptor descriptor = new TableColumnDescriptor();
        descriptor.addVisibleColumn((DynamicTableColumn)new AddressTableColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new MatchTypeTableColumn(this), 0, true);
        descriptor.addVisibleColumn((DynamicTableColumn)new PostBitsColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new TotalBitsColumn(this));
        descriptor.addVisibleColumn((DynamicTableColumn)new PatternStringTableColumn());
        return descriptor;
    }

    protected void doLoad(Accumulator<PatternEvalRowObject> accumulator, TaskMonitor monitor) throws CancelledException {
        if (this.rowObjects != null) {
            accumulator.addAll(this.rowObjects);
        }
    }

    private class AddressTableColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, Address, Object> {
        private AddressTableColumn(PatternEvalTabelModel patternEvalTabelModel) {
        }

        public String getColumnName() {
            return "Address";
        }

        public Address getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getMatchedAddress();
        }
    }

    private class MatchTypeTableColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, PatternMatchType, Object> {
        private MatchTypeTableColumn(PatternEvalTabelModel patternEvalTabelModel) {
        }

        public String getColumnName() {
            return "Match Type";
        }

        public PatternMatchType getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getMatchType();
        }
    }

    private class PostBitsColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, Integer, Object> {
        private PostBitsColumn(PatternEvalTabelModel patternEvalTabelModel) {
        }

        public String getColumnName() {
            return "Postbits";
        }

        public Integer getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getPostBits();
        }
    }

    private class TotalBitsColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, Integer, Object> {
        private TotalBitsColumn(PatternEvalTabelModel patternEvalTabelModel) {
        }

        public String getColumnName() {
            return "Totalbits";
        }

        public Integer getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getTotalBits();
        }
    }

    private class PatternStringTableColumn
    extends AbstractDynamicTableColumn<PatternEvalRowObject, String, Object> {
        private PatternStringTableColumn() {
        }

        public String getColumnName() {
            return "Pattern";
        }

        public GColumnRenderer<String> getColumnRenderer() {
            return PatternEvalTabelModel.this.monospacedRenderer;
        }

        public String getValue(PatternEvalRowObject rowObject, Settings settings, Object data, ServiceProvider sProvider) throws IllegalArgumentException {
            return rowObject.getPatternString();
        }
    }
}

