/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.datastruct;

import generic.cache.Factory;
import ghidra.util.datastruct.ThreadUnsafeWeakSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

class ThreadSafeListenerStorage<T> {
    private Factory<Set<T>, Set<T>> factory;
    private Set<T> storage;
    private AtomicInteger iteratorCount = new AtomicInteger();

    ThreadSafeListenerStorage(boolean isWeak) {
        this(ThreadSafeListenerStorage.createFactory(isWeak));
    }

    ThreadSafeListenerStorage(Factory<Set<T>, Set<T>> factory) {
        this.factory = factory;
        this.storage = factory.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forEach(Consumer<T> c) {
        Set<T> toIterate = this.getSet();
        try {
            for (T t : toIterate) {
                c.accept(t);
            }
        }
        finally {
            this.iteratorCount.decrementAndGet();
        }
    }

    private synchronized Set<T> getSet() {
        this.iteratorCount.incrementAndGet();
        return this.storage;
    }

    synchronized boolean add(T t) {
        if (this.iteratorCount.get() != 0) {
            this.storage = this.factory.get(this.storage);
        }
        return this.storage.add(t);
    }

    synchronized boolean remove(Object t) {
        if (this.iteratorCount.get() != 0) {
            this.storage = this.factory.get(this.storage);
        }
        return this.storage.remove(t);
    }

    synchronized void clear() {
        this.storage = this.factory.get(null);
    }

    synchronized int size() {
        return this.storage.size();
    }

    private static <T> Factory<Set<T>, Set<T>> createFactory(boolean isWeak) {
        if (isWeak) {
            return new WeakSetFactory();
        }
        return new StrongSetFactory();
    }

    private static class WeakSetFactory<T>
    implements Factory<Set<T>, Set<T>> {
        private WeakSetFactory() {
        }

        @Override
        public Set<T> get(Set<T> set) {
            ThreadUnsafeWeakSet newSet = new ThreadUnsafeWeakSet();
            if (set != null) {
                newSet.addAll(set);
            }
            return newSet;
        }
    }

    private static class StrongSetFactory<T>
    implements Factory<Set<T>, Set<T>> {
        private StrongSetFactory() {
        }

        @Override
        public Set<T> get(Set<T> set) {
            HashSet<T> newSet = new HashSet<T>();
            if (set != null) {
                newSet.addAll(set);
            }
            return newSet;
        }
    }
}

