/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.control;

import java.awt.event.KeyListener;
import javax.swing.event.EventListenerList;
import org.jungrapht.visualization.control.AbstractGraphMouse;
import org.jungrapht.visualization.control.GraphMousePlugin;
import org.jungrapht.visualization.control.ModalGraphMouse;
import org.jungrapht.visualization.control.ScalingGraphMousePlugin;
import org.jungrapht.visualization.control.modal.Modal;

public abstract class AbstractModalGraphMouse
extends AbstractGraphMouse
implements ModalGraphMouse {
    protected Modal.Mode mode;
    protected EventListenerList listenerList = new EventListenerList();
    protected GraphMousePlugin translatingPlugin;
    protected GraphMousePlugin animatedPickingPlugin;
    protected GraphMousePlugin rotatingPlugin;
    protected GraphMousePlugin shearingPlugin;
    protected KeyListener modeKeyListener;

    protected AbstractModalGraphMouse(Builder<?, ?> builder) {
        this(builder.mode, builder.in, builder.out, builder.vertexSelectionOnly);
    }

    protected AbstractModalGraphMouse(Modal.Mode mode, float in, float out, boolean vertexSelectionOnly) {
        super(in, out, vertexSelectionOnly);
        this.mode = mode;
    }

    @Override
    public void setMode(Modal.Mode mode) {
        this.mode = mode;
        if (mode == Modal.Mode.TRANSFORMING) {
            this.setTransformingMode();
        } else if (mode == Modal.Mode.PICKING) {
            this.setPickingMode();
        }
    }

    @Override
    public Modal.Mode getMode() {
        return this.mode;
    }

    protected void setPickingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.selectingPlugin);
        this.add(this.regionSelectingPlugin);
    }

    protected void setTransformingMode() {
        this.clear();
        this.add(this.scalingPlugin);
        this.add(this.translatingPlugin);
        this.add(this.rotatingPlugin);
        this.add(this.shearingPlugin);
    }

    @Override
    public void setZoomAtMouse(boolean zoomAtMouse) {
        ((ScalingGraphMousePlugin)this.scalingPlugin).setZoomAtMouse(zoomAtMouse);
    }

    @Override
    public KeyListener getModeKeyListener() {
        return this.modeKeyListener;
    }

    public void setModeKeyListener(KeyListener modeKeyListener) {
        this.modeKeyListener = modeKeyListener;
    }

    public static abstract class Builder<T extends AbstractModalGraphMouse, B extends Builder<T, B>>
    extends AbstractGraphMouse.Builder<T, B> {
        protected Modal.Mode mode = Modal.Mode.TRANSFORMING;

        public B mode(Modal.Mode mode) {
            this.mode = mode;
            return (B)this;
        }

        @Override
        public abstract T build();
    }
}

