/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.list;

import docking.widgets.list.GListCellRenderer;
import generic.theme.GColor;
import generic.theme.LafType;
import generic.theme.ThemeManager;
import java.awt.Color;
import java.awt.Font;
import java.util.function.Function;

public class GComboBoxCellRenderer<E>
extends GListCellRenderer<E> {
    private static final Color COMBO_BOX_BACKGROUND_COLOR = new GColor("color.bg.combobox.row");

    public static <E> GComboBoxCellRenderer<E> createDefaultTextRenderer(final Function<E, String> cellToTextMappingFunction) {
        return new GComboBoxCellRenderer<E>(){

            @Override
            protected String getItemText(E value) {
                return (String)cellToTextMappingFunction.apply(value);
            }
        };
    }

    @Override
    protected Color getDefaultBackgroundColor() {
        return COMBO_BOX_BACKGROUND_COLOR;
    }

    @Override
    protected void checkForInvalidSetFont(Font f) {
        if (ThemeManager.getInstance().getLookAndFeelType() == LafType.METAL) {
            return;
        }
        super.checkForInvalidSetFont(f);
    }
}

