/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.store.remote;

import db.buffers.BufferFile;
import db.buffers.LocalBufferFile;
import db.buffers.ManagedBufferFileAdapter;
import ghidra.framework.Application;
import ghidra.framework.client.RepositoryAdapter;
import ghidra.framework.remote.RepositoryItem;
import ghidra.framework.store.DatabaseItem;
import ghidra.framework.store.local.ItemSerializer;
import ghidra.framework.store.remote.RemoteFolderItem;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class RemoteDatabaseItem
extends RemoteFolderItem
implements DatabaseItem {
    RemoteDatabaseItem(RepositoryAdapter repository, RepositoryItem item) {
        super(repository, item);
    }

    @Override
    public long length() throws IOException {
        return this.repository.getLength(this.parentPath, this.itemName);
    }

    @Override
    int getItemType() {
        return 2;
    }

    @Override
    public boolean canRecover() {
        return false;
    }

    public ManagedBufferFileAdapter open(int fileVersion, int minChangeDataVer) throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, fileVersion, minChangeDataVer);
    }

    public ManagedBufferFileAdapter open(int fileVersion) throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, fileVersion, -1);
    }

    public ManagedBufferFileAdapter open() throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, -1, -1);
    }

    public ManagedBufferFileAdapter openForUpdate(long checkoutId) throws IOException {
        return this.repository.openDatabase(this.parentPath, this.itemName, checkoutId);
    }

    @Override
    public void updateCheckoutVersion(long checkoutId, int checkoutVersion, String user) throws IOException {
        this.repository.updateCheckoutVersion(this.parentPath, this.itemName, checkoutId, checkoutVersion);
    }

    @Override
    public boolean hasCheckouts() throws IOException {
        return this.repository.hasCheckouts(this.parentPath, this.itemName);
    }

    @Override
    public boolean isCheckinActive() throws IOException {
        return this.repository.isCheckinActive(this.parentPath, this.itemName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void output(File outputFile, int fileVersion, TaskMonitor monitor) throws IOException, CancelledException {
        try (ManagedBufferFileAdapter bf = this.repository.openDatabase(this.parentPath, this.itemName, fileVersion, -1);){
            File tmpFile = Application.createTempFile((String)"ghidra", (String)".tmp");
            tmpFile.delete();
            LocalBufferFile tmpBf = new LocalBufferFile(tmpFile, bf.getBufferSize());
            try {
                LocalBufferFile.copyFile((BufferFile)bf, (BufferFile)tmpBf, null, (TaskMonitor)monitor);
                tmpBf.close();
                try (FileInputStream itemIn = new FileInputStream(tmpFile);){
                    ItemSerializer.outputItem(this.getName(), this.getContentType(), 0, tmpFile.length(), itemIn, outputFile, monitor);
                }
            }
            finally {
                tmpBf.close();
                tmpFile.delete();
            }
        }
    }
}

