/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.actions;

import docking.ComponentProvider;
import docking.action.DockingActionIf;
import docking.action.KeyBindingType;
import docking.action.MenuData;
import docking.widgets.table.GTable;
import ghidra.app.context.ProgramSymbolActionContext;
import ghidra.app.context.ProgramSymbolContextAction;
import ghidra.app.nav.Navigatable;
import ghidra.app.plugin.core.symtable.SymbolEditor;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolRowObject;
import ghidra.app.plugin.core.symtable.TransientSymbolTableDnDAdapter;
import ghidra.app.plugin.core.symtable.TransientSymbolTableModel;
import ghidra.app.plugin.core.table.TableComponentProvider;
import ghidra.app.services.GoToService;
import ghidra.app.util.SymbolInspector;
import ghidra.app.util.query.TableService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraThreadedTablePanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CreateSymbolTableAction
extends ProgramSymbolContextAction {
    private Plugin plugin;

    public CreateSymbolTableAction(Plugin plugin) {
        super("Create Table", plugin.getName(), KeyBindingType.SHARED);
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Create Table"}, "0Middle"));
        this.setHelpLocation(new HelpLocation("SymbolTablePlugin", "Temporary_Symbol_Table"));
    }

    @Override
    protected boolean isEnabledForContext(ProgramSymbolActionContext context) {
        return context.getSymbolCount() != 0;
    }

    @Override
    protected void actionPerformed(ProgramSymbolActionContext context) {
        TableService service;
        HashSet<SymbolRowObject> rowObjects = new HashSet<SymbolRowObject>();
        Iterable<Symbol> symbols = context.getSymbols();
        for (Symbol symbol : symbols) {
            rowObjects.add(new SymbolRowObject(symbol));
        }
        PluginTool tool = this.plugin.getTool();
        Program program = context.getProgram();
        TransientSymbolTableModel model = new TransientSymbolTableModel(tool, program, rowObjects);
        Navigatable navigatable = null;
        GoToService goToService = (GoToService)tool.getService(GoToService.class);
        if (goToService != null) {
            navigatable = goToService.getDefaultNavigatable();
        }
        if ((service = (TableService)tool.getService(TableService.class)) == null) {
            Msg.showError((Object)((Object)this), null, (String)"Table Service Not Installed", (Object)"You must have a Table Service installed to create a Symbol Table");
            return;
        }
        TableComponentProvider<SymbolRowObject> provider = service.showTable("Symbols", "Symbols", model, "Symbols", navigatable);
        provider.setActionContextProvider(mouseEvent -> {
            GhidraThreadedTablePanel tablePanel = provider.getThreadedTablePanel();
            GTable table = tablePanel.getTable();
            List<Symbol> selectedSymbols = this.getSelectedSymbols(table, model);
            return new ProgramSymbolActionContext((ComponentProvider)provider, program, selectedSymbols, (Component)table);
        });
        provider.setHelpLocation(this.getHelpLocation());
        this.addActions(provider, model);
        GhidraThreadedTablePanel<SymbolRowObject> tablePanel = provider.getThreadedTablePanel();
        GhidraTable table = tablePanel.getTable();
        this.configureSymbolTable(tool, table, model, program);
    }

    private void addActions(TableComponentProvider<SymbolRowObject> provider, TransientSymbolTableModel model) {
        provider.installRemoveItemsAction();
        CreateSymbolTableAction tableAction = new CreateSymbolTableAction(this.plugin);
        provider.getTool().addLocalAction(provider, (DockingActionIf)tableAction);
    }

    private void configureSymbolTable(PluginTool tool, GhidraTable table, TransientSymbolTableModel model, Program program) {
        new TransientSymbolTableDnDAdapter(table, model);
        SymbolInspector symbolInspector = new SymbolInspector((ServiceProvider)tool, (Component)((Object)table));
        SymbolRenderer renderer = model.getSymbolRenderer();
        renderer.setSymbolInspector(symbolInspector);
        TableColumnModel columnModel = table.getColumnModel();
        int n = table.getColumnCount();
        for (int i = 0; i < n; ++i) {
            TableColumn column = columnModel.getColumn(i);
            column.setCellRenderer((TableCellRenderer)((Object)renderer));
            if (column.getModelIndex() != 0) continue;
            column.setCellEditor(new SymbolEditor());
        }
    }

    private List<Symbol> getSelectedSymbols(GTable table, TransientSymbolTableModel model) {
        int[] rows;
        ArrayList<Symbol> list = new ArrayList<Symbol>();
        for (int row : rows = table.getSelectedRows()) {
            SymbolRowObject rowObject = (SymbolRowObject)model.getRowObject(row);
            Symbol s = rowObject.getSymbol();
            if (s == null) continue;
            list.add(s);
        }
        return list;
    }
}

