/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.CompositeFieldElement;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import ghidra.app.util.NamespaceUtils;
import ghidra.app.util.viewer.field.AnnotatedStringHandler;
import ghidra.app.util.viewer.field.Annotation;
import ghidra.app.util.viewer.field.AnnotationCommentPart;
import ghidra.app.util.viewer.field.CommentPart;
import ghidra.app.util.viewer.field.InvalidAnnotatedStringHandler;
import ghidra.app.util.viewer.field.StringCommentPart;
import ghidra.app.util.viewer.field.SymbolAnnotatedStringHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CommentType;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.util.StringUtilities;
import ghidra.util.WordLocation;
import ghidra.util.bean.field.AnnotatedTextFieldElement;
import ghidra.util.classfinder.ClassSearcher;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class CommentUtils {
    private static final Pattern ANNOTATION_START_PATTERN = CommentUtils.createAnnotationStartPattern();
    private static List<AnnotatedStringHandler> ANNOTATED_STRING_HANDLERS;
    private static Map<String, AnnotatedStringHandler> ANNOTATED_STRING_MAP;

    public static String fixupAnnotations(String rawCommentText, Program program) {
        if (rawCommentText == null) {
            return null;
        }
        Function<Annotation, Annotation> symbolFixer = annotation -> {
            String[] annotationParts = annotation.getAnnotationParts();
            AnnotatedStringHandler handler = CommentUtils.getAnnotationHandler(annotationParts);
            if (!(handler instanceof SymbolAnnotatedStringHandler)) {
                return annotation;
            }
            String rawText = annotation.getAnnotationText();
            String updatedText = CommentUtils.convertAnnotationSymbolToAddress(annotationParts, rawText, program);
            if (updatedText == null) {
                return annotation;
            }
            return new Annotation(updatedText, program);
        };
        StringBuilder buffy = new StringBuilder();
        List<CommentPart> parts = CommentUtils.doParseTextIntoParts(rawCommentText, symbolFixer, program);
        for (CommentPart part : parts) {
            buffy.append(part.getRawText());
        }
        return buffy.toString();
    }

    private static AttributedString createPrototype() {
        Font dummyFont = Gui.getFont((String)"font.monospaced");
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(dummyFont);
        return new AttributedString("", (Color)GThemeDefaults.Colors.FOREGROUND, fontMetrics);
    }

    public static String getDisplayString(String rawCommentText, Program program) {
        AttributedString prototype = CommentUtils.createPrototype();
        FieldElement element = CommentUtils.parseTextForAnnotations(rawCommentText, program, prototype, 0);
        String displayText = element.getText();
        return displayText;
    }

    public static FieldElement parseTextForAnnotations(String text, Program program, AttributedString prototypeString, int row) {
        Function<Annotation, Annotation> noFixing = Function.identity();
        return CommentUtils.createFieldElementForAnnotations(text, noFixing, program, prototypeString, row);
    }

    public static String sanitize(String text) {
        if (text == null) {
            return null;
        }
        return text.replaceAll("\u0000", "");
    }

    private static FieldElement createFieldElementForAnnotations(String text, Function<Annotation, Annotation> fixerUpper, Program program, AttributedString prototype, int row) {
        text = StringUtilities.convertTabsToSpaces((String)text);
        int column = 0;
        List<CommentPart> parts = CommentUtils.doParseTextIntoParts(text, fixerUpper, program);
        ArrayList<FieldElement> fields = new ArrayList<FieldElement>();
        for (CommentPart part : parts) {
            FieldElement f = CommentUtils.createElement(part, prototype, program, row, column);
            fields.add(f);
            column += part.getDisplayText().length();
        }
        return new CompositeFieldElement(fields.toArray(new FieldElement[fields.size()]));
    }

    private static FieldElement createElement(CommentPart part, AttributedString prototype, Program p, int row, int column) {
        if (part instanceof AnnotationCommentPart) {
            AnnotationCommentPart annotationPart = (AnnotationCommentPart)part;
            Annotation annotation = annotationPart.getAnnotation();
            return new AnnotatedTextFieldElement(annotation, prototype, p, row, column);
        }
        AttributedString as = prototype.deriveAttributedString(part.getDisplayText());
        return new TextFieldElement(as, row, column);
    }

    private static List<CommentPart> doParseTextIntoParts(String text, Function<Annotation, Annotation> fixerUpper, Program program) {
        ArrayList<CommentPart> results = new ArrayList<CommentPart>();
        List<WordLocation> annotations = CommentUtils.getCommentAnnotations(text);
        if (annotations.isEmpty()) {
            results.add(new StringCommentPart(text));
            return results;
        }
        int offset = 0;
        for (WordLocation word : annotations) {
            int start = word.getStart();
            if (offset != start) {
                String preceding = text.substring(offset, start);
                results.add(new StringCommentPart(preceding));
            }
            String annotationText = word.getWord();
            Annotation annotation = new Annotation(annotationText, program);
            annotation = fixerUpper.apply(annotation);
            results.add(new AnnotationCommentPart(annotationText, annotation));
            offset = start + annotationText.length();
        }
        if (offset != text.length()) {
            String trailing = text.substring(offset);
            results.add(new StringCommentPart(trailing));
        }
        return results;
    }

    static List<WordLocation> getCommentAnnotations(String comment) {
        ArrayList<WordLocation> starts = new ArrayList<WordLocation>();
        Matcher matcher = ANNOTATION_START_PATTERN.matcher(comment);
        while (matcher.find()) {
            int position = matcher.start();
            String text = matcher.group();
            starts.add(new WordLocation(comment, text, position));
        }
        ArrayList<WordLocation> results = new ArrayList<WordLocation>();
        for (WordLocation word : starts) {
            int start = word.getStart();
            int offset = start + word.getWord().length();
            int end = CommentUtils.findAnnotationEnd(comment, offset);
            if (end == -1) continue;
            String annotation = comment.substring(start, end);
            results.add(new WordLocation(comment, annotation, start));
        }
        return results;
    }

    private static Pattern createAnnotationStartPattern() {
        Set<String> names = CommentUtils.getAnnotationNames();
        String namePatternString = StringUtils.join(names, (String)"|");
        return Pattern.compile("(?<!\\\\)(\\{@(" + namePatternString + ")\\s+?)");
    }

    private static int findAnnotationEnd(String comment, int start) {
        boolean escaped = false;
        boolean inQuote = false;
        for (int i = start; i < comment.length(); ++i) {
            boolean wasEscaped = escaped;
            escaped = false;
            int prev = 0;
            if (i != 0 && !wasEscaped) {
                prev = comment.charAt(i - 1);
            }
            char c = comment.charAt(i);
            if (prev == 92 && "{}\"\\".indexOf(c) != -1) {
                escaped = true;
                continue;
            }
            if (c == '\"') {
                inQuote = !inQuote;
                continue;
            }
            if (c != '}' || inQuote) continue;
            return i + 1;
        }
        return -1;
    }

    private static String convertAnnotationSymbolToAddress(String[] annotationParts, String rawText, Program program) {
        if (annotationParts.length <= 1) {
            return null;
        }
        if (program == null) {
            return null;
        }
        Address address = program.getAddressFactory().getAddress(annotationParts[1]);
        if (address != null) {
            return null;
        }
        String originalValue = annotationParts[1];
        List<Symbol> symbols = CommentUtils.getSymbols(originalValue, program);
        if (symbols.size() != 1) {
            return null;
        }
        Address symbolAddress = symbols.get(0).getAddress();
        return rawText.replaceFirst(Pattern.quote(originalValue), symbolAddress.toString());
    }

    public static List<Symbol> getSymbols(String rawText, Program program) {
        SymbolTable symbolTable;
        Symbol symbol;
        List list = NamespaceUtils.getSymbols((String)rawText, (Program)program);
        if (!list.isEmpty()) {
            return list;
        }
        Address address = program.getAddressFactory().getAddress(rawText);
        if (address != null && (symbol = (symbolTable = program.getSymbolTable()).getPrimarySymbol(address)) != null) {
            return Arrays.asList(symbol);
        }
        return Collections.emptyList();
    }

    public static AnnotatedStringHandler getAnnotationHandler(String[] annotationParts) {
        if (annotationParts.length <= 1) {
            return new InvalidAnnotatedStringHandler("Invalid annotation format. Expected at least two strings.");
        }
        String keyword = annotationParts[0];
        AnnotatedStringHandler handler = CommentUtils.getAnnotatedStringHandlerMap().get(keyword);
        if (handler == null) {
            return new InvalidAnnotatedStringHandler("Invalid annotation keyword: " + keyword);
        }
        return handler;
    }

    public static List<AnnotatedStringHandler> getAnnotatedStringHandlers() {
        if (ANNOTATED_STRING_HANDLERS == null) {
            ANNOTATED_STRING_HANDLERS = CommentUtils.getSupportedAnnotationHandlers();
        }
        return ANNOTATED_STRING_HANDLERS;
    }

    private static Map<String, AnnotatedStringHandler> getAnnotatedStringHandlerMap() {
        if (ANNOTATED_STRING_MAP == null) {
            ANNOTATED_STRING_MAP = CommentUtils.createAnnotatedStringHandlerMap();
        }
        return ANNOTATED_STRING_MAP;
    }

    private static Map<String, AnnotatedStringHandler> createAnnotatedStringHandlerMap() {
        HashMap<String, AnnotatedStringHandler> map = new HashMap<String, AnnotatedStringHandler>();
        for (AnnotatedStringHandler instance : CommentUtils.getAnnotatedStringHandlers()) {
            String[] supportedAnnotations;
            for (String supportedAnnotation : supportedAnnotations = instance.getSupportedAnnotations()) {
                map.put(supportedAnnotation, instance);
            }
        }
        return Collections.unmodifiableMap(map);
    }

    private static List<AnnotatedStringHandler> getSupportedAnnotationHandlers() {
        ArrayList<AnnotatedStringHandler> list = new ArrayList<AnnotatedStringHandler>();
        for (AnnotatedStringHandler h : ClassSearcher.getInstances(AnnotatedStringHandler.class)) {
            if (h.getSupportedAnnotations().length == 0) continue;
            list.add(h);
        }
        return Collections.unmodifiableList(list);
    }

    static Set<String> getAnnotationNames() {
        return Collections.unmodifiableSet(CommentUtils.getAnnotatedStringHandlerMap().keySet());
    }

    public static List<String> getOffcutComments(CodeUnit cu, CommentType type) {
        AddressSet addrSet;
        Data data;
        if (type == CommentType.EOL && cu instanceof Data && (data = (Data)cu).getNumComponents() > 0) {
            return Collections.emptyList();
        }
        Address start = cu.getMinAddress().next();
        Address end = cu.getMaxAddress();
        if (start == null || start.compareTo((Object)end) > 0) {
            return Collections.emptyList();
        }
        Listing listing = cu.getProgram().getListing();
        AddressIterator it = listing.getCommentAddressIterator(type, (AddressSetView)(addrSet = new AddressSet(start, cu.getMaxAddress())), true);
        if (!it.hasNext()) {
            return Collections.emptyList();
        }
        ArrayList<String> offcutComments = new ArrayList<String>();
        while (it.hasNext()) {
            String[] lines;
            Address next = it.next();
            String comment = listing.getComment(type, next);
            if (comment == null) continue;
            for (String line : lines = StringUtilities.toLines((String)comment)) {
                offcutComments.add(line);
            }
        }
        return offcutComments;
    }
}

