/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.task;

import ghidra.app.plugin.core.analysis.AnalysisWorker;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.feature.vt.api.db.VTSessionDB;
import ghidra.feature.vt.api.main.VTAssociation;
import ghidra.feature.vt.api.main.VTAssociationStatus;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMarkupItemApplyActionType;
import ghidra.feature.vt.api.main.VTMarkupItemConsideredStatus;
import ghidra.feature.vt.api.main.VTMarkupItemStatus;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.markuptype.VTMarkupType;
import ghidra.feature.vt.api.util.VTAssociationStatusException;
import ghidra.feature.vt.api.util.VersionTrackingApplyException;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.task.VtTask;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.feature.vt.gui.util.VTOptionDefines;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;

public class ApplyMatchTask
extends VtTask {
    protected final VTController controller;
    private final VTSessionDB sessionDB;
    private final List<VTMatch> matches;
    private final ToolOptions applyOptions;
    private boolean ignoreExcludedItem;
    private boolean ignoreIncompleteItem;

    public ApplyMatchTask(VTController controller, List<VTMatch> matches) {
        super("Apply Matches", controller.getSession());
        this.controller = controller;
        this.applyOptions = controller.getOptions();
        this.matches = matches;
        if (!(this.session instanceof VTSessionDB)) {
            throw new IllegalArgumentException("Unexpected condition - VTSession is not a DB object!  Found: " + String.valueOf(this.session));
        }
        this.sessionDB = (VTSessionDB)this.session;
        this.ignoreExcludedItem = this.applyOptions.getBoolean("Apply Markup Options.Set Excluded Markup Items To Ignored", VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_EXCLUDED_MARKUP_ITEMS);
        this.ignoreIncompleteItem = this.applyOptions.getBoolean("Apply Markup Options.Set Incomplete Markup Items To Ignored", VTOptionDefines.DEFAULT_OPTION_FOR_IGNORE_INCOMPLETE_MARKUP_ITEMS);
    }

    @Override
    protected boolean shouldSuspendSessionEvents() {
        return this.matches.size() > 20;
    }

    @Override
    protected boolean doWork(TaskMonitor monitor) throws Exception {
        Program destinationProgram = this.sessionDB.getDestinationProgram();
        AutoAnalysisManager manager = AutoAnalysisManager.getAnalysisManager((Program)destinationProgram);
        return manager.scheduleWorker(new AnalysisWorker(){

            public String getWorkerName() {
                return ApplyMatchTask.this.getTaskTitle();
            }

            public boolean analysisWorkerCallback(Program program, Object workerContext, TaskMonitor taskMonitor) throws CancelledException {
                ApplyMatchTask.this.applyMatches(taskMonitor);
                return true;
            }
        }, null, false, monitor);
    }

    private void applyMatches(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Processing matches");
        monitor.initialize((long)this.matches.size());
        for (VTMatch match : this.matches) {
            monitor.checkCancelled();
            VTAssociation association = match.getAssociation();
            VTAssociationStatus status = association.getStatus();
            if (!status.canApply()) continue;
            this.acceptMatch(match);
            long progress = monitor.getProgress();
            MatchInfo matchInfo = this.controller.getMatchInfo(match);
            Collection<VTMarkupItem> markupItems = matchInfo.getAppliableMarkupItems(monitor);
            if (markupItems == null || markupItems.size() == 0) {
                monitor.incrementProgress(1L);
                continue;
            }
            monitor.setMessage("Processing matches");
            monitor.setProgress(progress);
            this.applyMarkupItems(monitor, markupItems);
            monitor.incrementProgress(1L);
        }
        monitor.setProgress((long)this.matches.size());
    }

    private void acceptMatch(VTMatch match) {
        VTAssociation association = match.getAssociation();
        VTAssociationStatus status = association.getStatus();
        if (status == VTAssociationStatus.ACCEPTED) {
            return;
        }
        try {
            association.setAccepted();
        }
        catch (VTAssociationStatusException e) {
            throw new AssertException("Should have been given an association that is not blocked - current status: " + String.valueOf((Object)association.getStatus()));
        }
    }

    private void applyMarkupItems(TaskMonitor monitor, Collection<VTMarkupItem> markupItems) throws CancelledException {
        for (VTMarkupItem item : markupItems) {
            monitor.checkCancelled();
            VTMarkupItemStatus status = item.getStatus();
            if (status != VTMarkupItemStatus.UNAPPLIED) continue;
            try {
                this.applyMarkupItem(item);
            }
            catch (VersionTrackingApplyException e) {
                this.reportError(e);
            }
        }
    }

    private void applyMarkupItem(VTMarkupItem item) throws VersionTrackingApplyException {
        Address destinationAddress = item.getDestinationAddress();
        if (destinationAddress == null || destinationAddress == Address.NO_ADDRESS) {
            if (this.ignoreIncompleteItem) {
                item.setConsidered(VTMarkupItemConsideredStatus.IGNORE_DONT_CARE);
            }
            return;
        }
        VTMarkupType markupType = item.getMarkupType();
        VTMarkupItemApplyActionType applyAction = markupType.getApplyAction(this.applyOptions);
        if (applyAction == null) {
            if (item.canApply() && this.ignoreExcludedItem) {
                item.setConsidered(VTMarkupItemConsideredStatus.IGNORE_DONT_CARE);
            }
            return;
        }
        item.apply(applyAction, this.applyOptions);
    }
}

