/*
 * Decompiled with CFR 0.152.
 */
package ghidra;

import generic.jar.ResourceFile;
import ghidra.GhidraApplicationLayout;
import ghidra.framework.GModule;
import ghidra.util.Msg;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import utility.module.ModuleUtilities;

public class GhidraJarApplicationLayout
extends GhidraApplicationLayout {
    @Override
    public boolean inSingleJarMode() {
        return true;
    }

    @Override
    protected Collection<ResourceFile> findGhidraApplicationRootDirs() {
        ArrayList<ResourceFile> dirs = new ArrayList<ResourceFile>();
        String appPropPath = "/_Root/Ghidra/application.properties";
        URL appPropUrl = this.getClass().getResource(appPropPath);
        if (appPropUrl == null) {
            throw new IllegalStateException("The Ghidra Jar must have an application.properties file at " + appPropPath);
        }
        ResourceFile rootDir = this.fromUrl(appPropUrl).getParentFile();
        dirs.add(rootDir);
        return dirs;
    }

    @Override
    protected ResourceFile findGhidraApplicationInstallationDir() {
        if (this.getApplicationRootDirs().isEmpty()) {
            return null;
        }
        return this.getApplicationRootDirs().iterator().next().getParentFile();
    }

    @Override
    protected Map<String, GModule> findGhidraModules() throws IOException {
        return ModuleUtilities.findModules(this.getApplicationRootDirs(), ModuleUtilities.findJarModuleRootDirectories(this.getApplicationRootDirs().iterator().next(), new ArrayList<ResourceFile>()));
    }

    @Override
    protected ResourceFile findExtensionArchiveDirectory() {
        return null;
    }

    @Override
    protected List<ResourceFile> findExtensionInstallationDirectories() {
        String path = "/_Root/Ghidra/Extensions";
        URL extensionInstallUrl = this.getClass().getResource(path);
        if (extensionInstallUrl == null) {
            Msg.debug(this, "No Extensions dir found at " + path);
            return List.of();
        }
        ResourceFile extensionInstallDir = this.fromUrl(extensionInstallUrl);
        return Collections.singletonList(extensionInstallDir);
    }

    private ResourceFile fromUrl(URL url) {
        String urlString = url.toExternalForm();
        try {
            urlString = URLDecoder.decode(urlString, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return new ResourceFile(urlString);
    }
}

