/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.ChainedBuffer;
import db.DBRecord;
import db.Field;
import db.FixedKeyNode;
import db.FixedKeyRecordNode;
import db.NodeMgr;
import db.Schema;
import db.buffers.DataBuffer;
import ghidra.util.datastruct.IntArrayList;
import ghidra.util.exception.AssertException;
import java.io.IOException;

class FixedKeyVarRecNode
extends FixedKeyRecordNode {
    private static final int HEADER_SIZE = 13;
    private static final int OFFSET_SIZE = 4;
    private static final int INDIRECT_OPTION_SIZE = 1;
    private static final int KEY_BASE_OFFSET = 13;
    private final int entrySize;
    private final int dataOffsetBaseOffset;
    private final int indirectOptionBaseOffset;

    FixedKeyVarRecNode(NodeMgr nodeMgr, DataBuffer buf) throws IOException {
        super(nodeMgr, buf);
        this.entrySize = this.keySize + 4 + 1;
        this.dataOffsetBaseOffset = 13 + this.keySize;
        this.indirectOptionBaseOffset = this.dataOffsetBaseOffset + 4;
    }

    FixedKeyVarRecNode(NodeMgr nodeMgr, int prevLeafId, int nextLeafId) throws IOException {
        super(nodeMgr, (byte)6, prevLeafId, nextLeafId);
        this.entrySize = this.keySize + 4 + 1;
        this.dataOffsetBaseOffset = 13 + this.keySize;
        this.indirectOptionBaseOffset = this.dataOffsetBaseOffset + 4;
    }

    @Override
    FixedKeyRecordNode createNewLeaf(int prevLeafId, int nextLeafId) throws IOException {
        return new FixedKeyVarRecNode(this.nodeMgr, prevLeafId, nextLeafId);
    }

    @Override
    public int getKeyOffset(int index) {
        return 13 + index * this.entrySize;
    }

    public int getRecordDataOffset(int index) {
        return this.buffer.getInt(this.dataOffsetBaseOffset + index * this.entrySize);
    }

    private void putRecordDataOffset(int index, int offset) {
        this.buffer.putInt(this.dataOffsetBaseOffset + index * this.entrySize, offset);
    }

    private boolean hasIndirectStorage(int index) {
        return this.buffer.getByte(this.indirectOptionBaseOffset + index * this.entrySize) != 0;
    }

    private void enableIndirectStorage(int index, boolean state) {
        this.buffer.putByte(this.indirectOptionBaseOffset + index * this.entrySize, state ? (byte)1 : 0);
    }

    private int getFreeSpace() {
        return (this.keyCount == 0 ? this.buffer.length() : this.getRecordDataOffset(this.keyCount - 1)) - this.keyCount * this.entrySize - 13;
    }

    private int getRecordLength(int index) {
        if (index == 0) {
            return this.buffer.length() - this.getRecordDataOffset(0);
        }
        return this.getRecordDataOffset(index - 1) - this.getRecordDataOffset(index);
    }

    private int getRecordLength(int index, int offset) {
        if (index == 0) {
            return this.buffer.length() - offset;
        }
        return this.getRecordDataOffset(index - 1) - offset;
    }

    private int moveRecords(int index, int offset) {
        int lastIndex = this.keyCount - 1;
        if (index == this.keyCount) {
            if (index == 0) {
                return this.buffer.length() + offset;
            }
            return this.getRecordDataOffset(lastIndex) + offset;
        }
        int start = this.getRecordDataOffset(lastIndex);
        int end = index == 0 ? this.buffer.length() : this.getRecordDataOffset(index - 1);
        int len = end - start;
        this.buffer.move(start, start + offset, len);
        for (int i = index; i < this.keyCount; ++i) {
            this.putRecordDataOffset(i, this.getRecordDataOffset(i) + offset);
        }
        return end + offset;
    }

    @Override
    public DBRecord getRecord(Schema schema, int index) throws IOException {
        Field key = this.getKeyField(index);
        DBRecord record = schema.createRecord(key);
        if (this.hasIndirectStorage(index)) {
            int bufId = this.buffer.getInt(this.getRecordDataOffset(index));
            ChainedBuffer chainedBuffer = new ChainedBuffer(this.nodeMgr.getBufferMgr(), bufId);
            record.read(chainedBuffer, 0);
        } else {
            record.read(this.buffer, this.getRecordDataOffset(index));
        }
        return record;
    }

    @Override
    public int getRecordOffset(int index) throws IOException {
        if (this.hasIndirectStorage(index)) {
            return -this.buffer.getInt(this.getRecordDataOffset(index));
        }
        return this.getRecordDataOffset(index);
    }

    @Override
    public DBRecord getRecord(Field key, Schema schema) throws IOException {
        int index = this.getKeyIndex(key);
        if (index < 0) {
            return null;
        }
        return this.getRecord(schema, index);
    }

    private int getSplitIndex() {
        int halfway = ((this.keyCount == 0 ? this.buffer.length() : this.getRecordDataOffset(this.keyCount - 1)) + this.buffer.length()) / 2;
        int min = 1;
        int max = this.keyCount - 1;
        while (min < max) {
            int i = (min + max) / 2;
            int offset = this.getRecordDataOffset(i);
            if (offset == halfway) {
                return i;
            }
            if (offset < halfway) {
                max = i - 1;
                continue;
            }
            min = i + 1;
        }
        return min;
    }

    @Override
    void splitData(FixedKeyRecordNode newRightLeaf) {
        FixedKeyVarRecNode rightNode = (FixedKeyVarRecNode)newRightLeaf;
        int splitIndex = this.getSplitIndex();
        int count = this.keyCount - splitIndex;
        int start = this.getRecordDataOffset(this.keyCount - 1);
        int end = this.getRecordDataOffset(splitIndex - 1);
        int splitLen = end - start;
        int rightOffset = this.buffer.length() - splitLen;
        DataBuffer newBuf = rightNode.buffer;
        newBuf.copy(rightOffset, this.buffer, start, splitLen);
        newBuf.copy(13, this.buffer, 13 + splitIndex * this.entrySize, count * this.entrySize);
        int offsetCorrection = this.buffer.length() - end;
        for (int i = 0; i < count; ++i) {
            rightNode.putRecordDataOffset(i, rightNode.getRecordDataOffset(i) + offsetCorrection);
        }
        this.setKeyCount(this.keyCount - count);
        rightNode.setKeyCount(count);
    }

    @Override
    FixedKeyNode updateRecord(int index, DBRecord record) throws IOException {
        boolean useIndirect;
        int offset = this.getRecordDataOffset(index);
        int oldLen = this.getRecordLength(index, offset);
        int len = record.length();
        int maxRecordLength = (this.buffer.length() - 13 >> 2) - this.entrySize;
        boolean wasIndirect = this.hasIndirectStorage(index);
        boolean bl = useIndirect = len > maxRecordLength;
        if (useIndirect) {
            len = 4;
            ChainedBuffer chainedBuffer = null;
            if (wasIndirect) {
                chainedBuffer = new ChainedBuffer(this.nodeMgr.getBufferMgr(), this.buffer.getInt(offset));
                chainedBuffer.setSize(record.length(), false);
            } else {
                chainedBuffer = new ChainedBuffer(record.length(), this.nodeMgr.getBufferMgr());
                this.buffer.putInt(offset + oldLen - 4, chainedBuffer.getId());
                this.enableIndirectStorage(index, true);
            }
            record.write(chainedBuffer, 0);
        } else if (wasIndirect) {
            this.removeChainedBuffer(this.buffer.getInt(offset));
            this.enableIndirectStorage(index, false);
        }
        if (useIndirect || len <= this.getFreeSpace() + oldLen) {
            int dataShift = oldLen - len;
            if (dataShift != 0) {
                offset = this.moveRecords(index + 1, dataShift);
                this.putRecordDataOffset(index, offset);
            }
            if (!useIndirect) {
                record.write(this.buffer, offset);
            }
            return this.getRoot();
        }
        Field key = record.getKeyField();
        FixedKeyRecordNode leaf = (FixedKeyRecordNode)this.deleteRecord(key, null).getLeafNode(key);
        return leaf.putRecord(record, null);
    }

    @Override
    boolean insertRecord(int index, DBRecord record) throws IOException {
        int maxRecordLength;
        boolean useIndirect;
        int len = record.length();
        boolean bl = useIndirect = len > (maxRecordLength = (this.buffer.length() - 13 >> 2) - this.entrySize);
        if (useIndirect) {
            len = 4;
        }
        if (len + this.entrySize > this.getFreeSpace()) {
            return false;
        }
        int offset = this.moveRecords(index, -len);
        int start = 13 + index * this.entrySize;
        len = (this.keyCount - index) * this.entrySize;
        this.buffer.move(start, start + this.entrySize, len);
        this.buffer.put(start, record.getKeyField().getBinaryData());
        this.buffer.putInt(start + this.keySize, offset);
        this.setKeyCount(this.keyCount + 1);
        if (useIndirect) {
            ChainedBuffer chainedBuffer = new ChainedBuffer(record.length(), this.nodeMgr.getBufferMgr());
            this.buffer.putInt(offset, chainedBuffer.getId());
            record.write(chainedBuffer, 0);
        } else {
            record.write(this.buffer, offset);
        }
        this.enableIndirectStorage(index, useIndirect);
        return true;
    }

    @Override
    public void remove(int index) throws IOException {
        if (index < 0 || index >= this.keyCount) {
            throw new AssertException();
        }
        if (this.hasIndirectStorage(index)) {
            this.removeChainedBuffer(this.buffer.getInt(this.getRecordDataOffset(index)));
            this.enableIndirectStorage(index, false);
        }
        int len = this.getRecordLength(index);
        this.moveRecords(index + 1, len);
        int start = 13 + (index + 1) * this.entrySize;
        len = (this.keyCount - index - 1) * this.entrySize;
        this.buffer.move(start, start - this.entrySize, len);
        this.setKeyCount(this.keyCount - 1);
    }

    @Override
    public FixedKeyNode removeLeaf() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            if (!this.hasIndirectStorage(index)) continue;
            this.removeChainedBuffer(this.buffer.getInt(this.getRecordDataOffset(index)));
        }
        return super.removeLeaf();
    }

    private void removeChainedBuffer(int bufferId) throws IOException {
        ChainedBuffer chainedBuffer = new ChainedBuffer(this.nodeMgr.getBufferMgr(), bufferId);
        chainedBuffer.delete();
    }

    @Override
    public void delete() throws IOException {
        for (int index = 0; index < this.keyCount; ++index) {
            if (!this.hasIndirectStorage(index)) continue;
            int offset = this.getRecordDataOffset(index);
            int bufferId = this.buffer.getInt(offset);
            this.removeChainedBuffer(bufferId);
            this.buffer.putInt(offset, -1);
        }
        this.nodeMgr.deleteNode(this);
    }

    @Override
    public int[] getBufferReferences() {
        IntArrayList idList = new IntArrayList();
        for (int i = 0; i < this.keyCount; ++i) {
            if (!this.hasIndirectStorage(i)) continue;
            int offset = this.getRecordDataOffset(i);
            idList.add(this.buffer.getInt(offset));
        }
        return idList.toArray();
    }
}

