# frozen_string_literal: true

class CreateVulnerabilityFlipGuards < Gitlab::Database::Migration[2.3]
  milestone '18.6'

  disable_ddl_transaction!

  # rubocop:disable Migration/EnsureFactoryForTable -- False Positive
  def up
    create_table :vulnerability_flip_guards, id: false, if_not_exists: true do |t|
      t.bigint :vulnerability_finding_id, primary_key: true, default: nil
      t.bigint :project_id, null: false

      t.datetime_with_timezone :first_automatic_transition_at, null: false
      t.integer :automated_transition_count, limit: 2, default: 1
      t.boolean :is_guarded, default: false, null: false

      t.datetime_with_timezone :last_automatic_transition_at, null: false
      t.timestamps_with_timezone null: false
    end

    add_concurrent_index :vulnerability_flip_guards, %i[project_id vulnerability_finding_id],
      name: 'idx_vuln_flip_guards_on_project_and_finding_id', if_not_exists: true

    add_concurrent_foreign_key :vulnerability_flip_guards, :vulnerability_occurrences,
      column: :vulnerability_finding_id, on_delete: :cascade, if_not_exists: true
  end

  def down
    drop_table :vulnerability_flip_guards
  end
  # rubocop:enable Migration/EnsureFactoryForTable -- False Positive
end
