/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type.format;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.NoSuchElementException;
import oracle.sql.json.OracleJsonParser;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.BooleanJavaType;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.descriptor.java.PrimitiveByteArrayJavaType;
import org.hibernate.type.format.JsonDocumentItemType;
import org.hibernate.type.format.JsonDocumentReader;

public class OsonDocumentReader
implements JsonDocumentReader {
    private final OracleJsonParser parser;
    private String currentKeyName;
    private Object currentValue;

    public OsonDocumentReader(OracleJsonParser parser) {
        this.parser = parser;
    }

    @Override
    public boolean hasNext() {
        return this.parser.hasNext();
    }

    @Override
    public JsonDocumentItemType next() {
        if (!this.parser.hasNext()) {
            throw new NoSuchElementException("No more item in JSON document");
        }
        OracleJsonParser.Event evt = this.parser.next();
        this.currentKeyName = null;
        this.currentValue = null;
        switch (evt) {
            case START_OBJECT: {
                return JsonDocumentItemType.OBJECT_START;
            }
            case END_OBJECT: {
                return JsonDocumentItemType.OBJECT_END;
            }
            case START_ARRAY: {
                return JsonDocumentItemType.ARRAY_START;
            }
            case END_ARRAY: {
                return JsonDocumentItemType.ARRAY_END;
            }
            case KEY_NAME: {
                this.currentKeyName = this.parser.getString();
                return JsonDocumentItemType.VALUE_KEY;
            }
            case VALUE_TIMESTAMPTZ: {
                this.currentValue = this.parser.getOffsetDateTime();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_DATE: 
            case VALUE_TIMESTAMP: {
                this.currentValue = this.parser.getLocalDateTime();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_INTERVALDS: {
                this.currentValue = this.parser.getDuration();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_INTERVALYM: {
                this.currentValue = this.parser.getPeriod();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_STRING: {
                this.currentValue = this.parser.getString();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_TRUE: {
                this.currentValue = Boolean.TRUE;
                return JsonDocumentItemType.BOOLEAN_VALUE;
            }
            case VALUE_FALSE: {
                this.currentValue = Boolean.FALSE;
                return JsonDocumentItemType.BOOLEAN_VALUE;
            }
            case VALUE_NULL: {
                this.currentValue = null;
                return JsonDocumentItemType.NULL_VALUE;
            }
            case VALUE_DECIMAL: {
                this.currentValue = this.parser.getBigDecimal();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_DOUBLE: {
                this.currentValue = this.parser.getDouble();
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_FLOAT: {
                this.currentValue = Float.valueOf(this.parser.getFloat());
                return JsonDocumentItemType.VALUE;
            }
            case VALUE_BINARY: {
                this.currentValue = this.parser.getBytes();
                return JsonDocumentItemType.VALUE;
            }
        }
        throw new IllegalStateException("Unknown OSON event: " + String.valueOf(evt));
    }

    @Override
    public String getObjectKeyName() {
        if (this.currentKeyName == null) {
            throw new IllegalStateException("no object key available");
        }
        return this.currentKeyName;
    }

    @Override
    public String getStringValue() {
        return (String)this.currentValue;
    }

    @Override
    public BigDecimal getBigDecimalValue() {
        return (BigDecimal)this.currentValue;
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return ((BigDecimal)this.currentValue).toBigInteger();
    }

    @Override
    public double getDoubleValue() {
        if (this.currentValue instanceof String) {
            return Double.parseDouble((String)this.currentValue);
        }
        return (Double)this.currentValue;
    }

    @Override
    public float getFloatValue() {
        if (this.currentValue instanceof String) {
            return Float.parseFloat((String)this.currentValue);
        }
        return ((Float)this.currentValue).floatValue();
    }

    @Override
    public long getLongValue() {
        if (this.currentValue instanceof String) {
            return Long.parseLong((String)this.currentValue);
        }
        return ((BigDecimal)this.currentValue).longValue();
    }

    @Override
    public int getIntegerValue() {
        if (this.currentValue instanceof String) {
            return Integer.parseInt((String)this.currentValue);
        }
        return ((BigDecimal)this.currentValue).intValue();
    }

    @Override
    public short getShortValue() {
        if (this.currentValue instanceof String) {
            return Short.parseShort((String)this.currentValue);
        }
        return ((BigDecimal)this.currentValue).shortValue();
    }

    @Override
    public byte getByteValue() {
        if (this.currentValue instanceof String) {
            return Byte.parseByte((String)this.currentValue);
        }
        return (Byte)this.currentValue;
    }

    @Override
    public boolean getBooleanValue() {
        if (this.currentValue instanceof String) {
            return (Boolean)BooleanJavaType.INSTANCE.fromEncodedString((String)this.currentValue);
        }
        return (Boolean)this.currentValue;
    }

    @Override
    public <T> T getValue(JavaType<T> javaType, WrapperOptions options) {
        if (this.currentValue instanceof String) {
            if (((String)this.currentValue).length() == 36 && javaType == PrimitiveByteArrayJavaType.INSTANCE) {
                return javaType.fromEncodedString(((String)this.currentValue).replaceAll("-", ""));
            }
            return javaType.fromEncodedString((String)this.currentValue);
        }
        Object theOneToBeUsed = this.currentValue;
        if (this.currentValue instanceof LocalDateTime) {
            if (Date.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = Date.valueOf(((LocalDateTime)this.currentValue).toLocalDate());
            } else if (LocalDate.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = ((LocalDateTime)this.currentValue).toLocalDate();
            } else if (LocalTime.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = ((LocalDateTime)this.currentValue).toLocalTime();
            } else if (Time.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = Time.valueOf(((LocalDateTime)this.currentValue).toLocalTime());
            } else if (Timestamp.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = Timestamp.valueOf((LocalDateTime)this.currentValue);
            } else if (LocalTime.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = ((LocalDateTime)this.currentValue).toLocalTime();
            } else if (java.util.Date.class.isAssignableFrom(javaType.getJavaTypeClass())) {
                theOneToBeUsed = java.util.Date.from(((LocalDateTime)this.currentValue).atZone(ZoneId.of("UTC")).toInstant());
            }
        }
        return javaType.wrap(theOneToBeUsed, options);
    }
}

