/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.randomcutforest.executor;

import com.amazon.randomcutforest.CommonUtils;
import com.amazon.randomcutforest.IComponentModel;
import com.amazon.randomcutforest.IMultiVisitorFactory;
import com.amazon.randomcutforest.IVisitorFactory;
import com.amazon.randomcutforest.executor.UpdateResult;
import com.amazon.randomcutforest.sampler.ISampled;
import com.amazon.randomcutforest.sampler.IStreamSampler;
import com.amazon.randomcutforest.tree.ITree;
import java.util.Optional;
import lombok.Generated;

public class SamplerPlusTree<P, Q>
implements IComponentModel<P, Q> {
    private ITree<P, Q> tree;
    private IStreamSampler<P> sampler;

    public SamplerPlusTree(IStreamSampler<P> sampler, ITree<P, Q> tree) {
        CommonUtils.checkNotNull(sampler, "sampler must not be null");
        CommonUtils.checkNotNull(tree, "tree must not be null");
        this.sampler = sampler;
        this.tree = tree;
    }

    @Override
    public UpdateResult<P> update(P point, long sequenceIndex) {
        Object deleteRef = null;
        if (this.sampler.acceptPoint(sequenceIndex)) {
            Optional<ISampled<P>> deletedPoint = this.sampler.getEvictedPoint();
            if (deletedPoint.isPresent()) {
                ISampled<P> p = deletedPoint.get();
                deleteRef = p.getValue();
                this.tree.deletePoint(deleteRef, p.getSequenceIndex());
            }
            P addedPoint = this.tree.addPoint(point, sequenceIndex);
            this.sampler.addPoint(addedPoint);
            return UpdateResult.builder().addedPoint(addedPoint).deletedPoint(deleteRef).build();
        }
        return UpdateResult.noop();
    }

    @Override
    public <R> R traverse(float[] point, IVisitorFactory<R> visitorFactory) {
        return this.tree.traverse(point, visitorFactory);
    }

    @Override
    public <R> R traverseMulti(float[] point, IMultiVisitorFactory<R> visitorFactory) {
        return this.tree.traverseMulti(point, visitorFactory);
    }

    @Override
    public <T> void setConfig(String name, T value, Class<T> clazz) {
        if ("bounding_box_cache_fraction".equals(name)) {
            this.tree.setConfig(name, value, clazz);
        } else if ("time_decay".equals(name)) {
            this.sampler.setConfig(name, value, clazz);
        } else {
            throw new IllegalArgumentException("Unsupported configuration setting: " + name);
        }
    }

    @Override
    public <T> T getConfig(String name, Class<T> clazz) {
        CommonUtils.checkNotNull(clazz, "clazz must not be null");
        if ("bounding_box_cache_fraction".equals(name)) {
            return this.tree.getConfig(name, clazz);
        }
        if ("time_decay".equals(name)) {
            return this.sampler.getConfig(name, clazz);
        }
        throw new IllegalArgumentException("Unsupported configuration setting: " + name);
    }

    @Override
    public boolean isOutputReady() {
        return this.tree.isOutputReady();
    }

    @Generated
    public ITree<P, Q> getTree() {
        return this.tree;
    }

    @Generated
    public IStreamSampler<P> getSampler() {
        return this.sampler;
    }
}

