/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.timeseries.util;

import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import org.opensearch.common.CheckedConsumer;
import org.opensearch.core.action.ActionListener;

public class ActionListenerExecutor {
    private ActionListenerExecutor() {
    }

    public static <Response> ActionListener<Response> wrap(final CheckedConsumer<Response, ? extends Exception> onResponse, final Consumer<Exception> onFailure, final ExecutorService executorService) {
        return new ActionListener<Response>(){

            public void onResponse(Response response) {
                executorService.execute(() -> {
                    try {
                        onResponse.accept(response);
                    }
                    catch (Exception e) {
                        this.onFailure(e);
                    }
                });
            }

            public void onFailure(Exception e) {
                onFailure.accept(e);
            }
        };
    }
}

