/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.index.query.parser;

import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.core.common.ParsingException;
import org.opensearch.core.common.io.stream.NamedWriteable;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.xcontent.ObjectParser;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentLocation;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.index.query.AbstractQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.knn.index.query.KNNQueryBuilder;
import org.opensearch.knn.index.query.parser.MethodParametersParser;
import org.opensearch.knn.index.query.parser.RescoreParser;
import org.opensearch.knn.index.query.rescore.RescoreContext;
import org.opensearch.knn.index.util.IndexUtil;

public final class KNNQueryBuilderParser {
    @Generated
    private static final Logger log = LogManager.getLogger(KNNQueryBuilderParser.class);
    private static final ObjectParser<KNNQueryBuilder.Builder, Void> INTERNAL_PARSER = KNNQueryBuilderParser.createInternalObjectParser();

    private static ObjectParser<KNNQueryBuilder.Builder, Void> createInternalObjectParser() {
        ObjectParser internalParser = new ObjectParser("knn", KNNQueryBuilder.Builder::new);
        internalParser.declareFloat(KNNQueryBuilder.Builder::boost, AbstractQueryBuilder.BOOST_FIELD);
        internalParser.declareString(KNNQueryBuilder.Builder::queryName, AbstractQueryBuilder.NAME_FIELD);
        internalParser.declareFloatArray((b, v) -> b.vector(KNNQueryBuilderParser.floatListToFloatArray(v)), KNNQueryBuilder.VECTOR_FIELD);
        internalParser.declareInt(KNNQueryBuilder.Builder::k, KNNQueryBuilder.K_FIELD);
        internalParser.declareBoolean((b, v) -> {
            if (IndexUtil.isClusterOnOrAfterMinRequiredVersion("ignore_unmapped")) {
                b.ignoreUnmapped((boolean)v);
            }
        }, KNNQueryBuilder.IGNORE_UNMAPPED_FIELD);
        internalParser.declareFloat(KNNQueryBuilder.Builder::maxDistance, KNNQueryBuilder.MAX_DISTANCE_FIELD);
        internalParser.declareFloat(KNNQueryBuilder.Builder::minScore, KNNQueryBuilder.MIN_SCORE_FIELD);
        internalParser.declareObject(KNNQueryBuilder.Builder::methodParameters, (p, v) -> MethodParametersParser.fromXContent(p), KNNQueryBuilder.METHOD_PARAMS_FIELD);
        internalParser.declareObject(KNNQueryBuilder.Builder::filter, (p, v) -> AbstractQueryBuilder.parseInnerQueryBuilder((XContentParser)p), KNNQueryBuilder.FILTER_FIELD);
        internalParser.declareField((p, v, c) -> {
            BiConsumer<KNNQueryBuilder.Builder, RescoreContext> consumer = KNNQueryBuilder.Builder::rescoreContext;
            BiFunction<XContentParser, Void, RescoreContext> objectParser = (_p, _v) -> RescoreParser.fromXContent(_p);
            Supplier<RescoreContext> defaultValue = RescoreContext::getDefault;
            if (p.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                if (p.booleanValue()) {
                    consumer.accept((KNNQueryBuilder.Builder)v, defaultValue.get());
                } else {
                    consumer.accept((KNNQueryBuilder.Builder)v, RescoreContext.EXPLICITLY_DISABLED_RESCORE_CONTEXT);
                }
            } else {
                consumer.accept((KNNQueryBuilder.Builder)v, objectParser.apply(p, (Void)c));
            }
        }, KNNQueryBuilder.RESCORE_FIELD, ObjectParser.ValueType.OBJECT_OR_BOOLEAN);
        internalParser.declareBoolean(KNNQueryBuilder.Builder::expandNested, KNNQueryBuilder.EXPAND_NESTED_FIELD);
        internalParser.declareExclusiveFieldSet(new String[]{KNNQueryBuilder.RESCORE_FIELD.getPreferredName(), KNNQueryBuilder.MAX_DISTANCE_FIELD.getPreferredName()});
        internalParser.declareExclusiveFieldSet(new String[]{KNNQueryBuilder.RESCORE_FIELD.getPreferredName(), KNNQueryBuilder.MIN_SCORE_FIELD.getPreferredName()});
        return internalParser;
    }

    public static KNNQueryBuilder.Builder streamInput(StreamInput in, Function<String, Boolean> minClusterVersionCheck) throws IOException {
        KNNQueryBuilder.Builder builder = new KNNQueryBuilder.Builder();
        builder.fieldName(in.readString());
        builder.vector(in.readFloatArray());
        if (minClusterVersionCheck.apply("null_k").booleanValue()) {
            builder.k(in.readOptionalInt());
        } else {
            builder.k(in.readInt());
        }
        builder.filter((QueryBuilder)in.readOptionalNamedWriteable(QueryBuilder.class));
        if (minClusterVersionCheck.apply("ignore_unmapped").booleanValue()) {
            builder.ignoreUnmapped(in.readOptionalBoolean());
        }
        if (minClusterVersionCheck.apply("radial_search").booleanValue()) {
            builder.maxDistance(in.readOptionalFloat());
        }
        if (minClusterVersionCheck.apply("radial_search").booleanValue()) {
            builder.minScore(in.readOptionalFloat());
        }
        if (minClusterVersionCheck.apply("method_parameters").booleanValue()) {
            builder.methodParameters(MethodParametersParser.streamInput(in, IndexUtil::isClusterOnOrAfterMinRequiredVersion));
        }
        if (minClusterVersionCheck.apply("rescore").booleanValue()) {
            builder.rescoreContext(RescoreParser.streamInput(in));
        }
        if (minClusterVersionCheck.apply("expand_nested_docs").booleanValue()) {
            builder.expandNested(in.readOptionalBoolean());
        }
        return builder;
    }

    public static void streamOutput(StreamOutput out, KNNQueryBuilder builder, Function<String, Boolean> minClusterVersionCheck) throws IOException {
        out.writeString(builder.fieldName());
        out.writeFloatArray((float[])builder.vector());
        if (minClusterVersionCheck.apply("null_k").booleanValue()) {
            out.writeOptionalInt(builder.getK());
        } else {
            out.writeInt(Optional.ofNullable(builder.getK()).orElse(0).intValue());
        }
        out.writeOptionalNamedWriteable((NamedWriteable)builder.getFilter());
        if (minClusterVersionCheck.apply("ignore_unmapped").booleanValue()) {
            out.writeOptionalBoolean(Boolean.valueOf(builder.isIgnoreUnmapped()));
        }
        if (minClusterVersionCheck.apply("radial_search").booleanValue()) {
            out.writeOptionalFloat(builder.getMaxDistance());
        }
        if (minClusterVersionCheck.apply("radial_search").booleanValue()) {
            out.writeOptionalFloat(builder.getMinScore());
        }
        if (minClusterVersionCheck.apply("method_parameters").booleanValue()) {
            MethodParametersParser.streamOutput(out, builder.getMethodParameters(), IndexUtil::isClusterOnOrAfterMinRequiredVersion);
        }
        if (minClusterVersionCheck.apply("rescore").booleanValue()) {
            RescoreParser.streamOutput(out, builder.getRescoreContext());
        }
        if (minClusterVersionCheck.apply("expand_nested_docs").booleanValue()) {
            out.writeOptionalBoolean(builder.getExpandNested());
        }
    }

    public static KNNQueryBuilder fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        String fieldName = null;
        String currentFieldName = null;
        KNNQueryBuilder.Builder builder = null;
        List vector = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (token == XContentParser.Token.START_OBJECT) {
                KNNQueryBuilderParser.throwParsingExceptionOnMultipleFields(parser.getTokenLocation(), fieldName, currentFieldName);
                fieldName = currentFieldName;
                builder = (KNNQueryBuilder.Builder)INTERNAL_PARSER.apply(parser, null);
                continue;
            }
            KNNQueryBuilderParser.throwParsingExceptionOnMultipleFields(parser.getTokenLocation(), fieldName, parser.currentName());
            fieldName = parser.currentName();
            vector = parser.list();
        }
        if (builder == null) {
            builder = KNNQueryBuilder.builder().vector(KNNQueryBuilderParser.objectsToFloats(vector));
        }
        builder.fieldName(fieldName);
        return builder.build();
    }

    public static void toXContent(XContentBuilder builder, ToXContent.Params params, KNNQueryBuilder knnQueryBuilder) throws IOException {
        builder.startObject("knn");
        builder.startObject(knnQueryBuilder.fieldName());
        builder.field(KNNQueryBuilder.VECTOR_FIELD.getPreferredName(), knnQueryBuilder.vector());
        if (knnQueryBuilder.getK() != null) {
            builder.field(KNNQueryBuilder.K_FIELD.getPreferredName(), knnQueryBuilder.getK());
        }
        if (knnQueryBuilder.getFilter() != null) {
            builder.field(KNNQueryBuilder.FILTER_FIELD.getPreferredName(), (ToXContent)knnQueryBuilder.getFilter());
        }
        if (knnQueryBuilder.getMaxDistance() != null) {
            builder.field(KNNQueryBuilder.MAX_DISTANCE_FIELD.getPreferredName(), knnQueryBuilder.getMaxDistance());
        }
        if (knnQueryBuilder.isIgnoreUnmapped()) {
            builder.field(KNNQueryBuilder.IGNORE_UNMAPPED_FIELD.getPreferredName(), knnQueryBuilder.isIgnoreUnmapped());
        }
        if (knnQueryBuilder.getMinScore() != null) {
            builder.field(KNNQueryBuilder.MIN_SCORE_FIELD.getPreferredName(), knnQueryBuilder.getMinScore());
        }
        if (knnQueryBuilder.getMethodParameters() != null) {
            MethodParametersParser.doXContent(builder, knnQueryBuilder.getMethodParameters());
        }
        if (knnQueryBuilder.getRescoreContext() != null) {
            RescoreParser.doXContent(builder, knnQueryBuilder.getRescoreContext());
        }
        builder.field(AbstractQueryBuilder.BOOST_FIELD.getPreferredName(), knnQueryBuilder.boost());
        if (knnQueryBuilder.queryName() != null) {
            builder.field(AbstractQueryBuilder.NAME_FIELD.getPreferredName(), knnQueryBuilder.queryName());
        }
        if (knnQueryBuilder.getExpandNested() != null) {
            builder.field("expand_nested_docs", knnQueryBuilder.getExpandNested());
        }
        builder.endObject();
        builder.endObject();
    }

    private static float[] floatListToFloatArray(List<Float> floats) {
        if (Objects.isNull(floats) || floats.isEmpty()) {
            throw new IllegalArgumentException(String.format("[%s] field 'vector' requires to be non-null and non-empty", "knn"));
        }
        float[] vec = new float[floats.size()];
        for (int i = 0; i < floats.size(); ++i) {
            vec[i] = floats.get(i).floatValue();
        }
        return vec;
    }

    private static float[] objectsToFloats(List<Object> objs) {
        if (Objects.isNull(objs) || objs.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field 'vector' requires to be non-null and non-empty", "knn"));
        }
        float[] vec = new float[objs.size()];
        for (int i = 0; i < objs.size(); ++i) {
            if (!(objs.get(i) instanceof Number)) {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "[%s] field 'vector' requires to be an array of numbers", "knn"));
            }
            vec[i] = ((Number)objs.get(i)).floatValue();
        }
        return vec;
    }

    private static void throwParsingExceptionOnMultipleFields(XContentLocation contentLocation, String processedFieldName, String currentFieldName) {
        if (processedFieldName != null) {
            throw new ParsingException(contentLocation, "[knn] query doesn't support multiple fields, found [" + processedFieldName + "] and [" + currentFieldName + "]", new Object[0]);
        }
    }
}

