/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.run;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.LazyRunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.lang.Language;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.jetbrains.python.PythonFileType;
import com.jetbrains.python.PythonLanguage;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.run.PythonConfigurationType;
import com.jetbrains.python.run.PythonRunConfiguration;
import com.jetbrains.python.run.RunnableScriptFilter;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PythonRunConfigurationProducer
extends LazyRunConfigurationProducer<PythonRunConfiguration>
implements DumbAware {
    @NotNull
    public ConfigurationFactory getConfigurationFactory() {
        PythonConfigurationType.PythonConfigurationFactory pythonConfigurationFactory = PythonConfigurationType.getInstance().getFactory();
        if (pythonConfigurationFactory == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(0);
        }
        return pythonConfigurationFactory;
    }

    protected boolean setupConfigurationFromContext(@NotNull PythonRunConfiguration configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        Module module2;
        Location location;
        if (configuration == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(1);
        }
        if (context == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(2);
        }
        if (sourceElement == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(3);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiFile script = location.getPsiElement().getContainingFile();
        if (!PythonRunConfigurationProducer.isAvailable(location, script)) {
            return false;
        }
        VirtualFile vFile = script.getVirtualFile();
        if (vFile == null) {
            return false;
        }
        configuration.setScriptName(vFile.getPath());
        VirtualFile parent = vFile.getParent();
        if (parent != null && StringUtil.isEmpty((String)configuration.getWorkingDirectory())) {
            configuration.setWorkingDirectory(parent.getPath());
        }
        if ((module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)script)) != null) {
            configuration.setUseModuleSdk(true);
            configuration.setModule(module2);
        }
        configuration.setGeneratedName();
        return true;
    }

    public boolean isConfigurationFromContext(@NotNull PythonRunConfiguration configuration, @NotNull ConfigurationContext context) {
        String path2;
        Location location;
        if (configuration == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(5);
        }
        if ((location = context.getLocation()) == null) {
            return false;
        }
        PsiFile script = location.getPsiElement().getContainingFile();
        if (!PythonRunConfigurationProducer.isAvailable(location, script)) {
            return false;
        }
        VirtualFile virtualFile = script.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (virtualFile instanceof LightVirtualFile) {
            return false;
        }
        String workingDirectory = configuration.getWorkingDirectory();
        String scriptName = configuration.getScriptName();
        return scriptName.equals(path2 = virtualFile.getPath()) || path2.equals(new File(workingDirectory, scriptName).getAbsolutePath());
    }

    private static boolean isAvailable(@NotNull Location location, @Nullable PsiFile script) {
        if (location == null) {
            PythonRunConfigurationProducer.$$$reportNull$$$0(6);
        }
        if (script == null || script.getFileType() != PythonFileType.INSTANCE || !script.getViewProvider().getBaseLanguage().isKindOf((Language)PythonLanguage.INSTANCE)) {
            return false;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)script);
        if (module2 != null) {
            for (RunnableScriptFilter f : RunnableScriptFilter.EP_NAME.getExtensionList()) {
                if (!f.isRunnableScript(script, module2, location, TypeEvalContext.userInitiated(location.getProject(), null))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isPreferredConfiguration(ConfigurationFromContext self, ConfigurationFromContext other) {
        return other.isProducedBy(PythonRunConfigurationProducer.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4, 5, 6 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/run/PythonRunConfigurationProducer";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationFactory";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/run/PythonRunConfigurationProducer";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setupConfigurationFromContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isConfigurationFromContext";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4, 5, 6 -> new IllegalArgumentException(string);
        };
    }
}

