/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.out.ByteXmlWriter;
import com.fasterxml.aalto.out.WriterConfig;
import com.fasterxml.aalto.util.XmlCharTypes;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public abstract class SingleByteXmlWriter
extends ByteXmlWriter {
    public SingleByteXmlWriter(WriterConfig cfg, OutputStream out, XmlCharTypes charTypes) {
        super(cfg, out, charTypes);
    }

    @Override
    public abstract int getHighestEncodable();

    @Override
    public abstract void writeRaw(char[] var1, int var2, int var3) throws IOException, XMLStreamException;

    @Override
    protected final void output2ByteChar(int ch) throws IOException, XMLStreamException {
        this.reportFailedEscaping("content", ch);
    }

    @Override
    protected final int outputStrictMultiByteChar(int ch, char[] cbuf, int inputOffset, int inputLen) throws IOException, XMLStreamException {
        this.reportFailedEscaping("content", ch);
        return 0;
    }

    @Override
    protected final int outputMultiByteChar(int ch, char[] cbuf, int inputOffset, int inputLen) throws IOException, XMLStreamException {
        if (ch >= 55296) {
            if (ch <= 57343) {
                if (inputOffset >= inputLen) {
                    this._surrogate = ch;
                } else {
                    char ch2 = cbuf[inputOffset++];
                    this.outputSurrogates(ch, ch2);
                }
                return inputOffset;
            }
            if (ch >= 65534) {
                this.reportInvalidChar(ch);
            }
        }
        this.writeAsEntity(ch);
        return inputOffset;
    }

    @Override
    protected final void outputSurrogates(int surr1, int surr2) throws IOException, XMLStreamException {
        this.writeAsEntity(this.calcSurrogate(surr1, surr2, " in content"));
    }
}

