/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.images.fileTypes.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.lang.Language;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.XmlCharsetDetector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.swing.Icon;
import org.intellij.images.fileTypes.impl.SvgLanguage;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SvgFileType
extends LanguageFileType
implements UIBasedFileType {
    public static final SvgFileType INSTANCE = new SvgFileType();

    private SvgFileType() {
        super((Language)SvgLanguage.INSTANCE);
    }

    public String getCharset(@NotNull VirtualFile file, byte @NotNull [] content) {
        if (file == null) {
            SvgFileType.$$$reportNull$$$0(0);
        }
        if (content == null) {
            SvgFileType.$$$reportNull$$$0(1);
        }
        LoadTextUtil.DetectResult guessed = LoadTextUtil.guessFromContent((VirtualFile)file, (byte[])content);
        String charset = guessed.hardCodedCharset != null ? guessed.hardCodedCharset.name() : XmlCharsetDetector.extractXmlEncodingFromProlog((byte[])content);
        return charset == null ? "UTF-8" : charset;
    }

    public Charset extractCharsetFromFileContent(Project project, @Nullable VirtualFile file, @NotNull CharSequence content) {
        String name;
        Charset charset;
        if (content == null) {
            SvgFileType.$$$reportNull$$$0(2);
        }
        return (charset = CharsetToolkit.forName((String)(name = XmlCharsetDetector.extractXmlEncodingFromProlog((CharSequence)content)))) == null ? StandardCharsets.UTF_8 : charset;
    }

    @NotNull
    public String getName() {
        return "SVG";
    }

    @NotNull
    public String getDescription() {
        String string = IdeBundle.message((String)"filetype.scalable.vector.graphics.description", (Object[])new Object[0]);
        if (string == null) {
            SvgFileType.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = IdeBundle.message((String)"filetype.scalable.vector.graphics.display.name", (Object[])new Object[0]);
        if (string == null) {
            SvgFileType.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public String getDefaultExtension() {
        return "svg";
    }

    public Icon getIcon() {
        return AllIcons.FileTypes.Image;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/images/fileTypes/impl/SvgFileType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/images/fileTypes/impl/SvgFileType";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCharset";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractCharsetFromFileContent";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4 -> new IllegalStateException(string);
        };
    }
}

