// SPDX-License-Identifier: Apache-2.0
// Copyright (C) 2019-2021 Xilinx, Inc. All rights reserved.
// Copyright (C) 2023-2025 Advanced Micro Devices, Inc. All rights reserved.
#ifndef XRT_VERSION_H_
#define XRT_VERSION_H_

static const char xrt_build_version[] = "2.21.0";

static const char xrt_build_version_branch[] = "makepkg";

static const char xrt_build_version_hash[] = "f848f6f093a174bbbe82b8a9b7fe44ff91295661";

static const char xrt_build_version_hash_date[] = "Wed, 29 Oct 2025 14:43:26 -0700";

static const char xrt_build_version_date_rfc[] = "Sat, 06 Dec 2025 16:42:25 +0000";

static const char xrt_build_version_date[] = "2025-12-06 16:42:03";

static const char xrt_modified_files[] = "";

#define XRT_DRIVER_VERSION "2.21.0,f848f6f093a174bbbe82b8a9b7fe44ff91295661"
#define XRT_PATCH 0
#define XRT_HEAD_COMMITS 8575
#define XRT_BRANCH_COMMITS -1

#include "xrt/detail/version-slim.h"

#ifdef __cplusplus
#include <iostream>
#include <string>

namespace xrt::version {

inline void
print(std::ostream & output)
{
  output << "       XRT Build Version: " << xrt_build_version << std::endl;
  output << "    Build Version Branch: " << xrt_build_version_branch << std::endl;
  output << "      Build Version Hash: " << xrt_build_version_hash << std::endl;
  output << " Build Version Hash Date: " << xrt_build_version_hash_date << std::endl;
  output << "      Build Version Date: " << xrt_build_version_date_rfc << std::endl;

  std::string modified_files(xrt_modified_files);
  if (modified_files.empty())
    return;

  const std::string& delimiters = ",";      // Our delimiter
  std::string::size_type last_pos = 0;
  int running_index = 1;
  while (last_pos < modified_files.length() + 1) {
    if (running_index == 1)
      output << "  Current Modified Files: ";
    else 
      output << "                          ";

    output << running_index++ << ") ";

    auto pos = modified_files.find_first_of(delimiters, last_pos);

    if (pos == std::string::npos)
      pos = modified_files.length();

    output << modified_files.substr(last_pos, pos - last_pos) << std::endl;
    
    last_pos = pos + 1;
  }
}

} // namespace xrt::version 
#endif // __cplusplus

#endif

