/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.indexmanagement.rollup.model;

import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.Version;
import org.opensearch.common.settings.IndexScopedSettings;
import org.opensearch.common.settings.Settings;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.indexmanagement.common.model.dimension.DateHistogram;
import org.opensearch.indexmanagement.common.model.dimension.Dimension;
import org.opensearch.indexmanagement.common.model.dimension.Histogram;
import org.opensearch.indexmanagement.common.model.dimension.Terms;
import org.opensearch.indexmanagement.opensearchapi.OpenSearchExtensionsKt;
import org.opensearch.indexmanagement.rollup.model.RollupMetrics;
import org.opensearch.jobscheduler.spi.ScheduledJobParameter;
import org.opensearch.jobscheduler.spi.schedule.CronSchedule;
import org.opensearch.jobscheduler.spi.schedule.IntervalSchedule;
import org.opensearch.jobscheduler.spi.schedule.Schedule;
import org.opensearch.jobscheduler.spi.schedule.ScheduleParser;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b+\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0086\b\u0018\u0000 t2\u00020\u00012\u00020\u0002:\u0001tB\u00cd\u0001\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0004\u0012\u0006\u0010\u0011\u001a\u00020\u0004\u0012\u0006\u0010\u0012\u001a\u00020\u0004\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u0012\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\b\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u001b\u001a\u00020\t\u0012\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017\u0012\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017\u0012\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\u0004\b\"\u0010#B\u0011\b\u0016\u0012\u0006\u0010$\u001a\u00020%\u00a2\u0006\u0004\b\"\u0010&J\b\u0010J\u001a\u00020\tH\u0016J\b\u0010K\u001a\u00020\u0004H\u0016J\n\u0010L\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010M\u001a\u00020\fH\u0016J\b\u0010N\u001a\u00020\u000eH\u0016J\r\u0010O\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010CJ\u0018\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020Q2\u0006\u0010S\u001a\u00020TH\u0016J\u0010\u0010U\u001a\u00020V2\u0006\u0010W\u001a\u00020XH\u0016J\t\u0010Y\u001a\u00020\u0004H\u00c6\u0003J\t\u0010Z\u001a\u00020\u0006H\u00c6\u0003J\t\u0010[\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\\\u001a\u00020\tH\u00c6\u0003J\t\u0010]\u001a\u00020\u0006H\u00c6\u0003J\t\u0010^\u001a\u00020\fH\u00c6\u0003J\t\u0010_\u001a\u00020\u000eH\u00c6\u0003J\u000b\u0010`\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\t\u0010a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010b\u001a\u00020\u0004H\u00c6\u0003J\t\u0010c\u001a\u00020\u0004H\u00c6\u0003J\u000b\u0010d\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\u000b\u0010e\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u00c6\u0003J\t\u0010g\u001a\u00020\u0019H\u00c6\u0003J\u0010\u0010h\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003\u00a2\u0006\u0002\u0010CJ\t\u0010i\u001a\u00020\tH\u00c6\u0003J\u000f\u0010j\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017H\u00c6\u0003J\u000f\u0010k\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017H\u00c6\u0003J\u000b\u0010l\u001a\u0004\u0018\u00010!H\u00c6\u0003J\u00f2\u0001\u0010m\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u00062\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u00042\b\b\u0002\u0010\u0011\u001a\u00020\u00042\b\b\u0002\u0010\u0012\u001a\u00020\u00042\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u001b\u001a\u00020\t2\u000e\b\u0002\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00172\u000e\b\u0002\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00172\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!H\u00c6\u0001\u00a2\u0006\u0002\u0010nJ\u0013\u0010o\u001a\u00020\t2\b\u0010p\u001a\u0004\u0018\u00010qH\u00d6\u0003J\t\u0010r\u001a\u00020\u0019H\u00d6\u0001J\t\u0010s\u001a\u00020\u0004H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010(R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010*R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\n\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010*R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00104R\u0011\u0010\u0010\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u0010(R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u0010(R\u0011\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u0010(R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u0013\u0010\u0015\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010(R\"\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u00178\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b<\u0010=\u001a\u0004\b>\u0010?R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0015\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\n\n\u0002\u0010D\u001a\u0004\bB\u0010CR\u0011\u0010\u001b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\bE\u0010-R\u0017\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010?R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\bG\u0010?R\u0013\u0010 \u001a\u0004\u0018\u00010!\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010I\u00a8\u0006u"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "Lorg/opensearch/jobscheduler/spi/ScheduledJobParameter;", "Lorg/opensearch/core/common/io/stream/Writeable;", "id", "", "seqNo", "", "primaryTerm", "enabled", "", "schemaVersion", "jobSchedule", "Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "jobLastUpdatedTime", "Ljava/time/Instant;", "jobEnabledTime", "description", "sourceIndex", "targetIndex", "targetIndexSettings", "Lorg/opensearch/common/settings/Settings;", "metadataID", "roles", "", "pageSize", "", "delay", "continuous", "dimensions", "Lorg/opensearch/indexmanagement/common/model/dimension/Dimension;", "metrics", "Lorg/opensearch/indexmanagement/rollup/model/RollupMetrics;", "user", "Lorg/opensearch/commons/authuser/User;", "<init>", "(Ljava/lang/String;JJZJLorg/opensearch/jobscheduler/spi/schedule/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/common/settings/Settings;Ljava/lang/String;Ljava/util/List;ILjava/lang/Long;ZLjava/util/List;Ljava/util/List;Lorg/opensearch/commons/authuser/User;)V", "sin", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getId", "()Ljava/lang/String;", "getSeqNo", "()J", "getPrimaryTerm", "getEnabled", "()Z", "getSchemaVersion", "getJobSchedule", "()Lorg/opensearch/jobscheduler/spi/schedule/Schedule;", "setJobSchedule", "(Lorg/opensearch/jobscheduler/spi/schedule/Schedule;)V", "getJobLastUpdatedTime", "()Ljava/time/Instant;", "getJobEnabledTime", "getDescription", "getSourceIndex", "getTargetIndex", "getTargetIndexSettings", "()Lorg/opensearch/common/settings/Settings;", "getMetadataID", "getRoles$annotations", "()V", "getRoles", "()Ljava/util/List;", "getPageSize", "()I", "getDelay", "()Ljava/lang/Long;", "Ljava/lang/Long;", "getContinuous", "getDimensions", "getMetrics", "getUser", "()Lorg/opensearch/commons/authuser/User;", "isEnabled", "getName", "getEnabledTime", "getSchedule", "getLastUpdateTime", "getLockDurationSeconds", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "writeTo", "", "out", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component19", "component20", "copy", "(Ljava/lang/String;JJZJLorg/opensearch/jobscheduler/spi/schedule/Schedule;Ljava/time/Instant;Ljava/time/Instant;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lorg/opensearch/common/settings/Settings;Ljava/lang/String;Ljava/util/List;ILjava/lang/Long;ZLjava/util/List;Ljava/util/List;Lorg/opensearch/commons/authuser/User;)Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "equals", "other", "", "hashCode", "toString", "Companion", "opensearch-index-management"})
@SourceDebugExtension(value={"SMAP\nRollup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rollup.kt\norg/opensearch/indexmanagement/rollup/model/Rollup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,407:1\n1#2:408\n774#3:409\n865#3,2:410\n37#4:412\n36#4,3:413\n37#4:416\n36#4,3:417\n37#4:420\n36#4,3:421\n*S KotlinDebug\n*F\n+ 1 Rollup.kt\norg/opensearch/indexmanagement/rollup/model/Rollup\n*L\n97#1:409\n97#1:410,2\n190#1:412\n190#1:413,3\n191#1:416\n191#1:417,3\n225#1:420\n225#1:421,3\n*E\n"})
public final class Rollup
implements ScheduledJobParameter,
Writeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    private final long seqNo;
    private final long primaryTerm;
    private final boolean enabled;
    private final long schemaVersion;
    @NotNull
    private Schedule jobSchedule;
    @NotNull
    private final Instant jobLastUpdatedTime;
    @Nullable
    private final Instant jobEnabledTime;
    @NotNull
    private final String description;
    @NotNull
    private final String sourceIndex;
    @NotNull
    private final String targetIndex;
    @Nullable
    private final Settings targetIndexSettings;
    @Nullable
    private final String metadataID;
    @NotNull
    private final List<String> roles;
    private final int pageSize;
    @Nullable
    private final Long delay;
    private final boolean continuous;
    @NotNull
    private final List<Dimension> dimensions;
    @NotNull
    private final List<RollupMetrics> metrics;
    @Nullable
    private final User user;
    public static final long ROLLUP_LOCK_DURATION_SECONDS = 1800L;
    @NotNull
    public static final String ROLLUP_TYPE = "rollup";
    @NotNull
    public static final String ROLLUP_ID_FIELD = "rollup_id";
    @NotNull
    public static final String ENABLED_FIELD = "enabled";
    @NotNull
    public static final String SCHEMA_VERSION_FIELD = "schema_version";
    @NotNull
    public static final String SCHEDULE_FIELD = "schedule";
    @NotNull
    public static final String LAST_UPDATED_TIME_FIELD = "last_updated_time";
    @NotNull
    public static final String ENABLED_TIME_FIELD = "enabled_time";
    @NotNull
    public static final String DESCRIPTION_FIELD = "description";
    @NotNull
    public static final String SOURCE_INDEX_FIELD = "source_index";
    @NotNull
    public static final String TARGET_INDEX_FIELD = "target_index";
    @NotNull
    public static final String TARGET_INDEX_SETTINGS_FIELD = "target_index_settings";
    @NotNull
    public static final String METADATA_ID_FIELD = "metadata_id";
    @NotNull
    public static final String ROLES_FIELD = "roles";
    @NotNull
    public static final String PAGE_SIZE_FIELD = "page_size";
    @NotNull
    public static final String DELAY_FIELD = "delay";
    @NotNull
    public static final String CONTINUOUS_FIELD = "continuous";
    @NotNull
    public static final String DIMENSIONS_FIELD = "dimensions";
    @NotNull
    public static final String METRICS_FIELD = "metrics";
    public static final int MINIMUM_JOB_INTERVAL = 1;
    public static final int MINIMUM_DELAY = 0;
    public static final int MINIMUM_PAGE_SIZE = 1;
    public static final int MAXIMUM_PAGE_SIZE = 10000;
    @NotNull
    public static final String ROLLUP_DOC_ID_FIELD = "rollup._id";
    @NotNull
    public static final String ROLLUP_DOC_COUNT_FIELD = "_doc_count";
    @NotNull
    public static final String ROLLUP_DOC_SCHEMA_VERSION_FIELD = "rollup._schema_version";
    @NotNull
    public static final String USER_FIELD = "user";

    /*
     * WARNING - void declaration
     */
    public Rollup(@NotNull String id, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, @NotNull Schedule jobSchedule, @NotNull Instant jobLastUpdatedTime, @Nullable Instant jobEnabledTime, @NotNull String description, @NotNull String sourceIndex, @NotNull String targetIndex, @Nullable Settings targetIndexSettings, @Nullable String metadataID, @NotNull List<String> roles, int pageSize, @Nullable Long delay, boolean continuous, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics, @Nullable User user) {
        void $this$filterTo$iv$iv;
        Schedule schedule;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkNotNullParameter((Object)jobLastUpdatedTime, (String)"jobLastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(roles, (String)ROLES_FIELD);
        Intrinsics.checkNotNullParameter(dimensions, (String)DIMENSIONS_FIELD);
        Intrinsics.checkNotNullParameter(metrics, (String)METRICS_FIELD);
        this.id = id;
        this.seqNo = seqNo;
        this.primaryTerm = primaryTerm;
        this.enabled = enabled;
        this.schemaVersion = schemaVersion;
        this.jobSchedule = jobSchedule;
        this.jobLastUpdatedTime = jobLastUpdatedTime;
        this.jobEnabledTime = jobEnabledTime;
        this.description = description;
        this.sourceIndex = sourceIndex;
        this.targetIndex = targetIndex;
        this.targetIndexSettings = targetIndexSettings;
        this.metadataID = metadataID;
        this.roles = roles;
        this.pageSize = pageSize;
        this.delay = delay;
        this.continuous = continuous;
        this.dimensions = dimensions;
        this.metrics = metrics;
        this.user = user;
        if (this.enabled) {
            v0 = this.jobEnabledTime;
            if (v0 == null) {
                boolean $i$a$-requireNotNull-Rollup$22 = false;
                String $i$a$-requireNotNull-Rollup$22 = "Job enabled time must be present if the job is enabled";
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$22.toString());
            }
        } else {
            if (!(this.jobEnabledTime == null)) {
                boolean $i$a$-require-Rollup$52 = false;
                String $i$a$-require-Rollup$52 = "Job enabled time must not be present if the job is disabled";
                throw new IllegalArgumentException($i$a$-require-Rollup$52.toString());
            }
            v0 = Unit.INSTANCE;
        }
        if (!Intrinsics.areEqual((Object)this.jobSchedule.getDelay(), (Object)this.delay) && this.continuous) {
            schedule = this.jobSchedule;
            if (schedule instanceof CronSchedule) {
                Schedule schedule2 = this.jobSchedule;
                Intrinsics.checkNotNull((Object)schedule2, (String)"null cannot be cast to non-null type org.opensearch.jobscheduler.spi.schedule.CronSchedule");
                CronSchedule cronSchedule = (CronSchedule)schedule2;
                Long l = this.delay;
                v3 = (Schedule)new CronSchedule(cronSchedule.getCronExpression(), cronSchedule.getTimeZone(), l != null ? l : 0L);
            } else if (schedule instanceof IntervalSchedule) {
                Schedule schedule3 = this.jobSchedule;
                Intrinsics.checkNotNull((Object)schedule3, (String)"null cannot be cast to non-null type org.opensearch.jobscheduler.spi.schedule.IntervalSchedule");
                IntervalSchedule intervalSchedule = (IntervalSchedule)schedule3;
                Long l = this.delay;
                v3 = (Schedule)new IntervalSchedule(intervalSchedule.getStartTime(), intervalSchedule.getInterval(), intervalSchedule.getUnit(), l != null ? l : 0L);
            } else {
                v3 = this.jobSchedule = this.jobSchedule;
            }
        }
        if (!((schedule = this.jobSchedule) instanceof CronSchedule) && schedule instanceof IntervalSchedule) {
            Schedule schedule4 = this.jobSchedule;
            Intrinsics.checkNotNull((Object)schedule4, (String)"null cannot be cast to non-null type org.opensearch.jobscheduler.spi.schedule.IntervalSchedule");
            if (!(((IntervalSchedule)schedule4).getInterval() >= 1)) {
                boolean $i$a$-require-Rollup$112 = false;
                String $i$a$-require-Rollup$112 = "Rollup job schedule interval must be greater than 0";
                throw new IllegalArgumentException($i$a$-require-Rollup$112.toString());
            }
        }
        if (!(!Intrinsics.areEqual((Object)this.sourceIndex, (Object)this.targetIndex))) {
            boolean $i$a$-require-Rollup$122 = false;
            String $i$a$-require-Rollup$122 = "Your source and target index cannot be the same";
            throw new IllegalArgumentException($i$a$-require-Rollup$122.toString());
        }
        if (this.targetIndexSettings != null) {
            new IndexScopedSettings(null, IndexScopedSettings.BUILT_IN_INDEX_SETTINGS).validate(this.targetIndexSettings, true);
        }
        Iterable $this$filter$iv = this.dimensions;
        boolean $i$f$filter = false;
        Iterable $i$a$-require-Rollup$112 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Dimension it = (Dimension)element$iv$iv;
            boolean bl = false;
            if (!(it.getType() == Dimension.Type.DATE_HISTOGRAM)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        if (!(((List)destination$iv$iv).size() == 1)) {
            boolean $i$a$-require-Rollup$132 = false;
            String $i$a$-require-Rollup$132 = "Must specify precisely one date histogram dimension";
            throw new IllegalArgumentException($i$a$-require-Rollup$132.toString());
        }
        if (!(((Dimension)CollectionsKt.first(this.dimensions)).getType() == Dimension.Type.DATE_HISTOGRAM)) {
            boolean $i$a$-require-Rollup$142 = false;
            String $i$a$-require-Rollup$142 = "The first dimension must be a date histogram";
            throw new IllegalArgumentException($i$a$-require-Rollup$142.toString());
        }
        int n = this.pageSize;
        if (!(1 <= n ? n < 10001 : false)) {
            boolean $i$a$-require-Rollup$152 = false;
            String $i$a$-require-Rollup$152 = "Page size must be between 1 and 10,000";
            throw new IllegalArgumentException($i$a$-require-Rollup$152.toString());
        }
        if (this.delay != null) {
            if (!(this.delay >= 0L)) {
                boolean $i$a$-require-Rollup$162 = false;
                String $i$a$-require-Rollup$162 = "Delay must be non-negative if set";
                throw new IllegalArgumentException($i$a$-require-Rollup$162.toString());
            }
            if (!(this.delay <= Instant.now().toEpochMilli())) {
                boolean bl = false;
                String string = "Delay must be less than the current unix time";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    public /* synthetic */ Rollup(String string, long l, long l2, boolean bl, long l3, Schedule schedule, Instant instant, Instant instant2, String string2, String string3, String string4, Settings settings, String string5, List list, int n, Long l4, boolean bl2, List list2, List list3, User user, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            string = "";
        }
        if ((n2 & 2) != 0) {
            l = -2L;
        }
        if ((n2 & 4) != 0) {
            l2 = 0L;
        }
        if ((n2 & 0x2000) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n2 & 0x80000) != 0) {
            user = null;
        }
        this(string, l, l2, bl, l3, schedule, instant, instant2, string2, string3, string4, settings, string5, list, n, l4, bl2, list2, list3, user);
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    public final long getSeqNo() {
        return this.seqNo;
    }

    public final long getPrimaryTerm() {
        return this.primaryTerm;
    }

    public final boolean getEnabled() {
        return this.enabled;
    }

    public final long getSchemaVersion() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule getJobSchedule() {
        return this.jobSchedule;
    }

    public final void setJobSchedule(@NotNull Schedule schedule) {
        Intrinsics.checkNotNullParameter((Object)schedule, (String)"<set-?>");
        this.jobSchedule = schedule;
    }

    @NotNull
    public final Instant getJobLastUpdatedTime() {
        return this.jobLastUpdatedTime;
    }

    @Nullable
    public final Instant getJobEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getSourceIndex() {
        return this.sourceIndex;
    }

    @NotNull
    public final String getTargetIndex() {
        return this.targetIndex;
    }

    @Nullable
    public final Settings getTargetIndexSettings() {
        return this.targetIndexSettings;
    }

    @Nullable
    public final String getMetadataID() {
        return this.metadataID;
    }

    @NotNull
    public final List<String> getRoles() {
        return this.roles;
    }

    @Deprecated(message="Will be ignored, to check the roles use user field")
    public static /* synthetic */ void getRoles$annotations() {
    }

    public final int getPageSize() {
        return this.pageSize;
    }

    @Nullable
    public final Long getDelay() {
        return this.delay;
    }

    public final boolean getContinuous() {
        return this.continuous;
    }

    @NotNull
    public final List<Dimension> getDimensions() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> getMetrics() {
        return this.metrics;
    }

    @Nullable
    public final User getUser() {
        return this.user;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    @NotNull
    public String getName() {
        return this.id;
    }

    @Nullable
    public Instant getEnabledTime() {
        return this.jobEnabledTime;
    }

    @NotNull
    public Schedule getSchedule() {
        return this.jobSchedule;
    }

    @NotNull
    public Instant getLastUpdateTime() {
        return this.jobLastUpdatedTime;
    }

    @NotNull
    public Long getLockDurationSeconds() {
        return 1800L;
    }

    public Rollup(@NotNull StreamInput sin) throws IOException {
        Intrinsics.checkNotNullParameter((Object)sin, (String)"sin");
        String string = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        StreamInput streamInput = sin;
        long l = sin.readLong();
        boolean bl = sin.readBoolean();
        long l2 = sin.readLong();
        long l3 = sin.readLong();
        String string2 = string;
        Rollup rollup2 = this;
        boolean bl2 = false;
        Enum enum_ = sin.readEnum(Companion.ScheduleType.class);
        if (enum_ == null) {
            boolean $i$a$-requireNotNull-Rollup$11$22 = false;
            String $i$a$-requireNotNull-Rollup$11$22 = "ScheduleType cannot be null";
            throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$11$22.toString());
        }
        Schedule schedule = switch (WhenMappings.$EnumSwitchMapping$0[((Companion.ScheduleType)enum_).ordinal()]) {
            case 1 -> (Schedule)new CronSchedule(sin);
            case 2 -> (Schedule)new IntervalSchedule(sin);
            default -> throw new NoWhenBranchMatchedException();
        };
        Instant instant = sin.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = sin.readOptionalInstant();
        String string3 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"readString(...)");
        String string4 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"readString(...)");
        String string5 = sin.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"readString(...)");
        Settings settings = sin.getVersion().onOrAfter(Version.V_3_0_0) && sin.readBoolean() ? Settings.readSettingsFromStream((StreamInput)sin) : null;
        String string6 = sin.readOptionalString();
        String[] stringArray = sin.readStringArray();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"readStringArray(...)");
        StreamInput it = sin;
        boolean bl3 = sin.readBoolean();
        Long l4 = sin.readOptionalLong();
        int n = sin.readInt();
        List list = ArraysKt.toList((Object[])stringArray);
        String string7 = string6;
        Settings settings2 = settings;
        String string8 = string5;
        String string9 = string4;
        String string10 = string3;
        Instant instant3 = instant2;
        Instant instant4 = instant;
        boolean bl4 = false;
        List dimensionsList = new ArrayList();
        int size = it.readVInt();
        for (int i = 0; i < size; ++i) {
            boolean bl5 = false;
            Dimension.Type type = (Dimension.Type)it.readEnum(Dimension.Type.class);
            List list2 = dimensionsList;
            Dimension.Type type2 = type;
            if (type2 == null) {
                List list3 = list2;
                boolean bl6 = false;
                List list4 = list3;
                String string11 = "Dimension type cannot be null";
                throw new IllegalArgumentException(string11.toString());
            }
            list2.add(switch (WhenMappings.$EnumSwitchMapping$1[type2.ordinal()]) {
                case 1 -> new DateHistogram(sin);
                case 2 -> new Terms(sin);
                case 3 -> new Histogram(sin);
                default -> throw new NoWhenBranchMatchedException();
            });
        }
        List list5 = CollectionsKt.toList((Iterable)dimensionsList);
        List list6 = sin.readList(RollupMetrics::new);
        Intrinsics.checkNotNullExpressionValue((Object)list6, (String)"readList(...)");
        rollup2(string2, l3, l2, bl, l, schedule, instant4, instant3, string10, string9, string8, settings2, string7, list, n, l4, bl3, list5, list6, sin.readBoolean() ? new User(sin) : null);
    }

    @NotNull
    public XContentBuilder toXContent(@NotNull XContentBuilder builder, @NotNull ToXContent.Params params) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        builder.startObject();
        if (params.paramAsBoolean("with_type", true)) {
            builder.startObject(ROLLUP_TYPE);
        }
        XContentBuilder xContentBuilder = builder.field(ROLLUP_ID_FIELD, this.id).field(ENABLED_FIELD, this.enabled).field(SCHEDULE_FIELD, (ToXContent)this.jobSchedule);
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"field(...)");
        Collection $this$toTypedArray$iv = this.dimensions;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        XContentBuilder xContentBuilder2 = OpenSearchExtensionsKt.optionalTimeField(OpenSearchExtensionsKt.optionalTimeField(xContentBuilder, LAST_UPDATED_TIME_FIELD, this.jobLastUpdatedTime), ENABLED_TIME_FIELD, this.jobEnabledTime).field(DESCRIPTION_FIELD, this.description).field(SCHEMA_VERSION_FIELD, this.schemaVersion).field(SOURCE_INDEX_FIELD, this.sourceIndex).field(TARGET_INDEX_FIELD, this.targetIndex).field(METADATA_ID_FIELD, this.metadataID).field(PAGE_SIZE_FIELD, this.pageSize).field(DELAY_FIELD, this.delay).field(CONTINUOUS_FIELD, this.continuous).field(DIMENSIONS_FIELD, (Object)thisCollection$iv.toArray(new Dimension[0]));
        $this$toTypedArray$iv = this.metrics;
        $i$f$toTypedArray = false;
        thisCollection$iv = $this$toTypedArray$iv;
        xContentBuilder2.field(METRICS_FIELD, (Object)thisCollection$iv.toArray(new RollupMetrics[0]));
        if (this.targetIndexSettings != null) {
            builder.startObject(TARGET_INDEX_SETTINGS_FIELD);
            this.targetIndexSettings.toXContent(builder, params);
            builder.endObject();
        }
        if (params.paramAsBoolean("with_user", true)) {
            OpenSearchExtensionsKt.optionalUserField(builder, USER_FIELD, this.user);
        }
        if (params.paramAsBoolean("with_type", true)) {
            builder.endObject();
        }
        builder.endObject();
        return builder;
    }

    public void writeTo(@NotNull StreamOutput out) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            out.writeString(this.id);
            out.writeLong(this.seqNo);
            out.writeLong(this.primaryTerm);
            out.writeBoolean(this.enabled);
            out.writeLong(this.schemaVersion);
            if (this.getSchedule() instanceof CronSchedule) {
                out.writeEnum((Enum)Companion.ScheduleType.CRON);
            } else {
                out.writeEnum((Enum)Companion.ScheduleType.INTERVAL);
            }
            this.getSchedule().writeTo(out);
            out.writeInstant(this.jobLastUpdatedTime);
            out.writeOptionalInstant(this.jobEnabledTime);
            out.writeString(this.description);
            out.writeString(this.sourceIndex);
            out.writeString(this.targetIndex);
            if (out.getVersion().onOrAfter(Version.V_3_0_0)) {
                out.writeBoolean(this.targetIndexSettings != null);
                if (this.targetIndexSettings != null) {
                    Settings.writeSettingsToStream((Settings)this.targetIndexSettings, (StreamOutput)out);
                }
            }
            out.writeOptionalString(this.metadataID);
            Collection $this$toTypedArray$iv = CollectionsKt.emptyList();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            out.writeStringArray(thisCollection$iv.toArray(new String[0]));
            out.writeInt(this.pageSize);
            out.writeOptionalLong(this.delay);
            out.writeBoolean(this.continuous);
            out.writeVInt(this.dimensions.size());
            for (Dimension dimension : this.dimensions) {
                out.writeEnum((Enum)dimension.getType());
                Dimension dimension2 = dimension;
                if (dimension2 instanceof DateHistogram) {
                    ((DateHistogram)dimension).writeTo(out);
                    continue;
                }
                if (dimension2 instanceof Terms) {
                    ((Terms)dimension).writeTo(out);
                    continue;
                }
                if (!(dimension2 instanceof Histogram)) continue;
                ((Histogram)dimension).writeTo(out);
            }
            out.writeCollection((Collection)this.metrics);
            out.writeBoolean(this.user != null);
            User user = this.user;
            if (user == null) break block7;
            user.writeTo(out);
        }
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    public final long component2() {
        return this.seqNo;
    }

    public final long component3() {
        return this.primaryTerm;
    }

    public final boolean component4() {
        return this.enabled;
    }

    public final long component5() {
        return this.schemaVersion;
    }

    @NotNull
    public final Schedule component6() {
        return this.jobSchedule;
    }

    @NotNull
    public final Instant component7() {
        return this.jobLastUpdatedTime;
    }

    @Nullable
    public final Instant component8() {
        return this.jobEnabledTime;
    }

    @NotNull
    public final String component9() {
        return this.description;
    }

    @NotNull
    public final String component10() {
        return this.sourceIndex;
    }

    @NotNull
    public final String component11() {
        return this.targetIndex;
    }

    @Nullable
    public final Settings component12() {
        return this.targetIndexSettings;
    }

    @Nullable
    public final String component13() {
        return this.metadataID;
    }

    @NotNull
    public final List<String> component14() {
        return this.roles;
    }

    public final int component15() {
        return this.pageSize;
    }

    @Nullable
    public final Long component16() {
        return this.delay;
    }

    public final boolean component17() {
        return this.continuous;
    }

    @NotNull
    public final List<Dimension> component18() {
        return this.dimensions;
    }

    @NotNull
    public final List<RollupMetrics> component19() {
        return this.metrics;
    }

    @Nullable
    public final User component20() {
        return this.user;
    }

    @NotNull
    public final Rollup copy(@NotNull String id, long seqNo, long primaryTerm, boolean enabled, long schemaVersion, @NotNull Schedule jobSchedule, @NotNull Instant jobLastUpdatedTime, @Nullable Instant jobEnabledTime, @NotNull String description, @NotNull String sourceIndex, @NotNull String targetIndex, @Nullable Settings targetIndexSettings, @Nullable String metadataID, @NotNull List<String> roles, int pageSize, @Nullable Long delay, boolean continuous, @NotNull List<? extends Dimension> dimensions, @NotNull List<RollupMetrics> metrics, @Nullable User user) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)jobSchedule, (String)"jobSchedule");
        Intrinsics.checkNotNullParameter((Object)jobLastUpdatedTime, (String)"jobLastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)description, (String)DESCRIPTION_FIELD);
        Intrinsics.checkNotNullParameter((Object)sourceIndex, (String)"sourceIndex");
        Intrinsics.checkNotNullParameter((Object)targetIndex, (String)"targetIndex");
        Intrinsics.checkNotNullParameter(roles, (String)ROLES_FIELD);
        Intrinsics.checkNotNullParameter(dimensions, (String)DIMENSIONS_FIELD);
        Intrinsics.checkNotNullParameter(metrics, (String)METRICS_FIELD);
        return new Rollup(id, seqNo, primaryTerm, enabled, schemaVersion, jobSchedule, jobLastUpdatedTime, jobEnabledTime, description, sourceIndex, targetIndex, targetIndexSettings, metadataID, roles, pageSize, delay, continuous, dimensions, metrics, user);
    }

    public static /* synthetic */ Rollup copy$default(Rollup rollup2, String string, long l, long l2, boolean bl, long l3, Schedule schedule, Instant instant, Instant instant2, String string2, String string3, String string4, Settings settings, String string5, List list, int n, Long l4, boolean bl2, List list2, List list3, User user, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = rollup2.id;
        }
        if ((n2 & 2) != 0) {
            l = rollup2.seqNo;
        }
        if ((n2 & 4) != 0) {
            l2 = rollup2.primaryTerm;
        }
        if ((n2 & 8) != 0) {
            bl = rollup2.enabled;
        }
        if ((n2 & 0x10) != 0) {
            l3 = rollup2.schemaVersion;
        }
        if ((n2 & 0x20) != 0) {
            schedule = rollup2.jobSchedule;
        }
        if ((n2 & 0x40) != 0) {
            instant = rollup2.jobLastUpdatedTime;
        }
        if ((n2 & 0x80) != 0) {
            instant2 = rollup2.jobEnabledTime;
        }
        if ((n2 & 0x100) != 0) {
            string2 = rollup2.description;
        }
        if ((n2 & 0x200) != 0) {
            string3 = rollup2.sourceIndex;
        }
        if ((n2 & 0x400) != 0) {
            string4 = rollup2.targetIndex;
        }
        if ((n2 & 0x800) != 0) {
            settings = rollup2.targetIndexSettings;
        }
        if ((n2 & 0x1000) != 0) {
            string5 = rollup2.metadataID;
        }
        if ((n2 & 0x2000) != 0) {
            list = rollup2.roles;
        }
        if ((n2 & 0x4000) != 0) {
            n = rollup2.pageSize;
        }
        if ((n2 & 0x8000) != 0) {
            l4 = rollup2.delay;
        }
        if ((n2 & 0x10000) != 0) {
            bl2 = rollup2.continuous;
        }
        if ((n2 & 0x20000) != 0) {
            list2 = rollup2.dimensions;
        }
        if ((n2 & 0x40000) != 0) {
            list3 = rollup2.metrics;
        }
        if ((n2 & 0x80000) != 0) {
            user = rollup2.user;
        }
        return rollup2.copy(string, l, l2, bl, l3, schedule, instant, instant2, string2, string3, string4, settings, string5, list, n, l4, bl2, list2, list3, user);
    }

    @NotNull
    public String toString() {
        return "Rollup(id=" + this.id + ", seqNo=" + this.seqNo + ", primaryTerm=" + this.primaryTerm + ", enabled=" + this.enabled + ", schemaVersion=" + this.schemaVersion + ", jobSchedule=" + this.jobSchedule + ", jobLastUpdatedTime=" + this.jobLastUpdatedTime + ", jobEnabledTime=" + this.jobEnabledTime + ", description=" + this.description + ", sourceIndex=" + this.sourceIndex + ", targetIndex=" + this.targetIndex + ", targetIndexSettings=" + this.targetIndexSettings + ", metadataID=" + this.metadataID + ", roles=" + this.roles + ", pageSize=" + this.pageSize + ", delay=" + this.delay + ", continuous=" + this.continuous + ", dimensions=" + this.dimensions + ", metrics=" + this.metrics + ", user=" + this.user + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.seqNo);
        result2 = result2 * 31 + Long.hashCode(this.primaryTerm);
        result2 = result2 * 31 + Boolean.hashCode(this.enabled);
        result2 = result2 * 31 + Long.hashCode(this.schemaVersion);
        result2 = result2 * 31 + this.jobSchedule.hashCode();
        result2 = result2 * 31 + this.jobLastUpdatedTime.hashCode();
        result2 = result2 * 31 + (this.jobEnabledTime == null ? 0 : this.jobEnabledTime.hashCode());
        result2 = result2 * 31 + this.description.hashCode();
        result2 = result2 * 31 + this.sourceIndex.hashCode();
        result2 = result2 * 31 + this.targetIndex.hashCode();
        result2 = result2 * 31 + (this.targetIndexSettings == null ? 0 : this.targetIndexSettings.hashCode());
        result2 = result2 * 31 + (this.metadataID == null ? 0 : this.metadataID.hashCode());
        result2 = result2 * 31 + ((Object)this.roles).hashCode();
        result2 = result2 * 31 + Integer.hashCode(this.pageSize);
        result2 = result2 * 31 + (this.delay == null ? 0 : ((Object)this.delay).hashCode());
        result2 = result2 * 31 + Boolean.hashCode(this.continuous);
        result2 = result2 * 31 + ((Object)this.dimensions).hashCode();
        result2 = result2 * 31 + ((Object)this.metrics).hashCode();
        result2 = result2 * 31 + (this.user == null ? 0 : this.user.hashCode());
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Rollup)) {
            return false;
        }
        Rollup rollup2 = (Rollup)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)rollup2.id)) {
            return false;
        }
        if (this.seqNo != rollup2.seqNo) {
            return false;
        }
        if (this.primaryTerm != rollup2.primaryTerm) {
            return false;
        }
        if (this.enabled != rollup2.enabled) {
            return false;
        }
        if (this.schemaVersion != rollup2.schemaVersion) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobSchedule, (Object)rollup2.jobSchedule)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobLastUpdatedTime, (Object)rollup2.jobLastUpdatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.jobEnabledTime, (Object)rollup2.jobEnabledTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.description, (Object)rollup2.description)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sourceIndex, (Object)rollup2.sourceIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndex, (Object)rollup2.targetIndex)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.targetIndexSettings, (Object)rollup2.targetIndexSettings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.metadataID, (Object)rollup2.metadataID)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.roles, rollup2.roles)) {
            return false;
        }
        if (this.pageSize != rollup2.pageSize) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.delay, (Object)rollup2.delay)) {
            return false;
        }
        if (this.continuous != rollup2.continuous) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dimensions, rollup2.dimensions)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.metrics, rollup2.metrics)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.user, (Object)rollup2.user);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
        return Companion.parse(xcp, id, seqNo, primaryTerm);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) throws IOException {
        return Companion.parse(xcp, id, seqNo);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
        return Companion.parse(xcp, id);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Rollup parse(@NotNull XContentParser xcp) throws IOException {
        return Companion.parse(xcp);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001)B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%2\b\b\u0002\u0010&\u001a\u00020\u00072\b\b\u0002\u0010'\u001a\u00020\u00052\b\b\u0002\u0010(\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001aX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001aX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001aX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/Rollup$Companion;", "", "<init>", "()V", "ROLLUP_LOCK_DURATION_SECONDS", "", "ROLLUP_TYPE", "", "ROLLUP_ID_FIELD", "ENABLED_FIELD", "SCHEMA_VERSION_FIELD", "SCHEDULE_FIELD", "LAST_UPDATED_TIME_FIELD", "ENABLED_TIME_FIELD", "DESCRIPTION_FIELD", "SOURCE_INDEX_FIELD", "TARGET_INDEX_FIELD", "TARGET_INDEX_SETTINGS_FIELD", "METADATA_ID_FIELD", "ROLES_FIELD", "PAGE_SIZE_FIELD", "DELAY_FIELD", "CONTINUOUS_FIELD", "DIMENSIONS_FIELD", "METRICS_FIELD", "MINIMUM_JOB_INTERVAL", "", "MINIMUM_DELAY", "MINIMUM_PAGE_SIZE", "MAXIMUM_PAGE_SIZE", "ROLLUP_DOC_ID_FIELD", "ROLLUP_DOC_COUNT_FIELD", "ROLLUP_DOC_SCHEMA_VERSION_FIELD", "USER_FIELD", "parse", "Lorg/opensearch/indexmanagement/rollup/model/Rollup;", "xcp", "Lorg/opensearch/core/xcontent/XContentParser;", "id", "seqNo", "primaryTerm", "ScheduleType", "opensearch-index-management"})
    @SourceDebugExtension(value={"SMAP\nRollup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rollup.kt\norg/opensearch/indexmanagement/rollup/model/Rollup$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,407:1\n1#2:408\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo, long primaryTerm) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Schedule schedule = null;
            long schemaVersion = 1L;
            Instant lastUpdatedTime = null;
            Instant enabledTime = null;
            boolean enabled = true;
            String description = null;
            String sourceIndex = null;
            String targetIndex = null;
            Settings targetIndexSettings = null;
            String metadataID = null;
            Integer pageSize = null;
            Long delay = null;
            boolean continuous = false;
            List dimensions = new ArrayList();
            List metrics = new ArrayList();
            User user = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
            while (xcp.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName = xcp.currentName();
                xcp.nextToken();
                String string = fieldName;
                if (string == null) throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Rollup.");
                int n = -1;
                switch (string.hashCode()) {
                    case -1219796725: {
                        if (string.equals(Rollup.ENABLED_TIME_FIELD)) {
                            n = 1;
                        }
                        break;
                    }
                    case -207303516: {
                        if (string.equals(Rollup.TARGET_INDEX_FIELD)) {
                            n = 2;
                        }
                        break;
                    }
                    case 108695229: {
                        if (string.equals(Rollup.ROLES_FIELD)) {
                            n = 3;
                        }
                        break;
                    }
                    case -1724546052: {
                        if (string.equals(Rollup.DESCRIPTION_FIELD)) {
                            n = 4;
                        }
                        break;
                    }
                    case 1156913502: {
                        if (string.equals(Rollup.TARGET_INDEX_SETTINGS_FIELD)) {
                            n = 5;
                        }
                        break;
                    }
                    case 1661088686: {
                        if (string.equals(Rollup.SOURCE_INDEX_FIELD)) {
                            n = 6;
                        }
                        break;
                    }
                    case -1609594047: {
                        if (string.equals(Rollup.ENABLED_FIELD)) {
                            n = 7;
                        }
                        break;
                    }
                    case 556621538: {
                        if (string.equals(Rollup.ROLLUP_ID_FIELD)) {
                            n = 8;
                        }
                        break;
                    }
                    case 1684719674: {
                        if (string.equals(Rollup.SCHEMA_VERSION_FIELD)) {
                            n = 9;
                        }
                        break;
                    }
                    case -697920873: {
                        if (string.equals(Rollup.SCHEDULE_FIELD)) {
                            n = 10;
                        }
                        break;
                    }
                    case 95467907: {
                        if (string.equals(Rollup.DELAY_FIELD)) {
                            n = 11;
                        }
                        break;
                    }
                    case -1670470950: {
                        if (string.equals(Rollup.LAST_UPDATED_TIME_FIELD)) {
                            n = 12;
                        }
                        break;
                    }
                    case 379114255: {
                        if (string.equals(Rollup.CONTINUOUS_FIELD)) {
                            n = 13;
                        }
                        break;
                    }
                    case -1481411541: {
                        if (string.equals(Rollup.METADATA_ID_FIELD)) {
                            n = 14;
                        }
                        break;
                    }
                    case 955826371: {
                        if (string.equals(Rollup.METRICS_FIELD)) {
                            n = 15;
                        }
                        break;
                    }
                    case 3599307: {
                        if (string.equals(Rollup.USER_FIELD)) {
                            n = 16;
                        }
                        break;
                    }
                    case 883849137: {
                        if (string.equals(Rollup.PAGE_SIZE_FIELD)) {
                            n = 17;
                        }
                        break;
                    }
                    case 414334925: {
                        if (string.equals(Rollup.DIMENSIONS_FIELD)) {
                            n = 18;
                        }
                        break;
                    }
                }
                switch (n) {
                    case 8: {
                        String string2 = xcp.text();
                        if (string2 != null) break;
                        boolean bl = false;
                        String string3 = "The rollup_id field is null";
                        throw new IllegalArgumentException(string3.toString());
                    }
                    case 7: {
                        enabled = xcp.booleanValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 10: {
                        schedule = ScheduleParser.parse((XContentParser)xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 9: {
                        schemaVersion = xcp.longValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 1: {
                        enabledTime = OpenSearchExtensionsKt.instant(xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 12: {
                        lastUpdatedTime = OpenSearchExtensionsKt.instant(xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 4: {
                        description = xcp.text();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 6: {
                        sourceIndex = xcp.text();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 2: {
                        targetIndex = xcp.text();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 5: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        targetIndexSettings = Settings.fromXContent((XContentParser)xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 14: {
                        metadataID = xcp.textOrNull();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 3: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            xcp.text();
                        }
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 17: {
                        pageSize = xcp.intValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 11: {
                        delay = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : Long.valueOf(xcp.longValue());
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 13: {
                        continuous = xcp.booleanValue();
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 18: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            dimensions.add(Dimension.Companion.parse(xcp));
                        }
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 15: {
                        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_ARRAY, (XContentParser.Token)xcp.currentToken(), (XContentParser)xcp);
                        while (xcp.nextToken() != XContentParser.Token.END_ARRAY) {
                            metrics.add(RollupMetrics.Companion.parse(xcp));
                        }
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    case 16: {
                        user = xcp.currentToken() == XContentParser.Token.VALUE_NULL ? null : User.parse((XContentParser)xcp);
                        String string2 = Unit.INSTANCE;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Invalid field [" + fieldName + "] found in Rollup.");
                    }
                }
            }
            if (enabled && enabledTime == null) {
                enabledTime = Instant.now();
            } else if (!enabled) {
                enabledTime = null;
            }
            if ((seqNo == -2L || primaryTerm == 0L) && schedule instanceof IntervalSchedule) {
                Instant instant = ((IntervalSchedule)schedule).getStartTime();
                if (instant == null) {
                    instant = Instant.now();
                }
                Long l = ((IntervalSchedule)schedule).getDelay();
                schedule = (Schedule)new IntervalSchedule(instant, ((IntervalSchedule)schedule).getInterval(), ((IntervalSchedule)schedule).getUnit(), l != null ? l : 0L);
            }
            String string = id;
            long l = seqNo;
            long l2 = primaryTerm;
            boolean bl = enabled;
            long l3 = schemaVersion;
            Schedule schedule2 = schedule;
            if (schedule2 == null) {
                long l4 = l3;
                boolean bl2 = bl;
                long l5 = l2;
                long l6 = l;
                String string4 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$72 = false;
                String string5 = "Rollup schedule is null";
                String string6 = string4;
                long l7 = l6;
                long l8 = l5;
                boolean bl3 = bl2;
                long l9 = l4;
                String $i$a$-requireNotNull-Rollup$Companion$parse$72 = string5;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$72.toString());
            }
            Instant instant = lastUpdatedTime;
            if (instant == null) {
                instant = Instant.now();
            }
            Instant $i$a$-requireNotNull-Rollup$Companion$parse$72 = instant;
            Intrinsics.checkNotNull((Object)$i$a$-requireNotNull-Rollup$Companion$parse$72);
            Instant instant2 = $i$a$-requireNotNull-Rollup$Companion$parse$72;
            Instant instant3 = enabledTime;
            String string7 = description;
            if (string7 == null) {
                Instant instant4 = instant3;
                Instant instant5 = instant2;
                Schedule schedule3 = schedule2;
                long l10 = l3;
                boolean bl4 = bl;
                long l11 = l2;
                long l12 = l;
                String string8 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$82 = false;
                String string9 = "Rollup description is null";
                String string10 = string8;
                long l13 = l12;
                long l14 = l11;
                boolean bl5 = bl4;
                long l15 = l10;
                Schedule schedule4 = schedule3;
                Instant instant6 = instant5;
                Instant instant7 = instant4;
                String $i$a$-requireNotNull-Rollup$Companion$parse$82 = string9;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$82.toString());
            }
            String string11 = sourceIndex;
            if (string11 == null) {
                String string12 = string7;
                Instant instant8 = instant3;
                Instant instant9 = instant2;
                Schedule schedule5 = schedule2;
                long l16 = l3;
                boolean bl6 = bl;
                long l17 = l2;
                long l18 = l;
                String string13 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$92 = false;
                String string14 = "Rollup source index is null";
                String string15 = string13;
                long l19 = l18;
                long l20 = l17;
                boolean bl7 = bl6;
                long l21 = l16;
                Schedule schedule6 = schedule5;
                Instant instant10 = instant9;
                Instant instant11 = instant8;
                String string16 = string12;
                String $i$a$-requireNotNull-Rollup$Companion$parse$92 = string14;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$92.toString());
            }
            String string17 = targetIndex;
            if (string17 == null) {
                String string18 = string11;
                String string19 = string7;
                Instant instant12 = instant3;
                Instant instant13 = instant2;
                Schedule schedule7 = schedule2;
                long l22 = l3;
                boolean bl8 = bl;
                long l23 = l2;
                long l24 = l;
                String string20 = string;
                boolean $i$a$-requireNotNull-Rollup$Companion$parse$102 = false;
                String string21 = "Rollup target index is null";
                String string22 = string20;
                long l25 = l24;
                long l26 = l23;
                boolean bl9 = bl8;
                long l27 = l22;
                Schedule schedule8 = schedule7;
                Instant instant14 = instant13;
                Instant instant15 = instant12;
                String string23 = string19;
                String string24 = string18;
                String $i$a$-requireNotNull-Rollup$Companion$parse$102 = string21;
                throw new IllegalArgumentException($i$a$-requireNotNull-Rollup$Companion$parse$102.toString());
            }
            Settings settings = targetIndexSettings;
            String string25 = metadataID;
            Integer n = pageSize;
            if (n == null) {
                List list = null;
                String string26 = string25;
                Settings settings2 = settings;
                String string27 = string17;
                String string28 = string11;
                String string29 = string7;
                Instant instant16 = instant3;
                Instant instant17 = instant2;
                Schedule schedule9 = schedule2;
                long l28 = l3;
                boolean bl10 = bl;
                long l29 = l2;
                long l30 = l;
                String string30 = string;
                boolean bl11 = false;
                String string31 = "Rollup page size is null";
                String string32 = string30;
                long l31 = l30;
                long l32 = l29;
                boolean bl12 = bl10;
                long l33 = l28;
                Schedule schedule10 = schedule9;
                Instant instant18 = instant17;
                Instant instant19 = instant16;
                String string33 = string29;
                String string34 = string28;
                String string35 = string27;
                Settings settings3 = settings2;
                String string36 = string26;
                List list2 = list;
                String string37 = string31;
                throw new IllegalArgumentException(string37.toString());
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n2 = 8192;
            User user2 = user;
            List list = metrics;
            List list3 = dimensions;
            boolean bl13 = continuous;
            Long l34 = delay;
            int n3 = ((Number)n).intValue();
            List list4 = null;
            String string38 = string25;
            Settings settings4 = settings;
            String string39 = string17;
            String string40 = string11;
            String string41 = string7;
            Instant instant20 = instant3;
            Instant instant21 = instant2;
            Schedule schedule11 = schedule2;
            long l35 = l3;
            boolean bl14 = bl;
            long l36 = l2;
            long l37 = l;
            String string42 = string;
            return new Rollup(string42, l37, l36, bl14, l35, schedule11, instant21, instant20, string41, string40, string39, settings4, string38, list4, n3, l34, bl13, list3, list, user2, n2, defaultConstructorMarker);
        }

        public static /* synthetic */ Rollup parse$default(Companion companion, XContentParser xContentParser, String string, long l, long l2, int n, Object object) throws IOException {
            if ((n & 2) != 0) {
                string = "";
            }
            if ((n & 4) != 0) {
                l = -2L;
            }
            if ((n & 8) != 0) {
                l2 = 0L;
            }
            return companion.parse(xContentParser, string, l, l2);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id, long seqNo) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, id, seqNo, 0L, 8, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp, @NotNull String id) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return org.opensearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, id, 0L, 0L, 12, null);
        }

        @JvmStatic
        @JvmOverloads
        @NotNull
        public final Rollup parse(@NotNull XContentParser xcp) throws IOException {
            Intrinsics.checkNotNullParameter((Object)xcp, (String)"xcp");
            return org.opensearch.indexmanagement.rollup.model.Rollup$Companion.parse$default(this, xcp, null, 0L, 0L, 14, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lorg/opensearch/indexmanagement/rollup/model/Rollup$Companion$ScheduleType;", "", "<init>", "(Ljava/lang/String;I)V", "CRON", "INTERVAL", "opensearch-index-management"})
        public static final class ScheduleType
        extends Enum<ScheduleType> {
            public static final /* enum */ ScheduleType CRON = new ScheduleType();
            public static final /* enum */ ScheduleType INTERVAL = new ScheduleType();
            private static final /* synthetic */ ScheduleType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            public static ScheduleType[] values() {
                return (ScheduleType[])$VALUES.clone();
            }

            public static ScheduleType valueOf(String value) {
                return Enum.valueOf(ScheduleType.class, value);
            }

            @NotNull
            public static EnumEntries<ScheduleType> getEntries() {
                return $ENTRIES;
            }

            static {
                $VALUES = scheduleTypeArray = new ScheduleType[]{ScheduleType.CRON, ScheduleType.INTERVAL};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Companion.ScheduleType.values().length];
            try {
                nArray[Companion.ScheduleType.CRON.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Companion.ScheduleType.INTERVAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Dimension.Type.values().length];
            try {
                nArray[Dimension.Type.DATE_HISTOGRAM.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.TERMS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dimension.Type.HISTOGRAM.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

