/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.action;

import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionEmbeddedGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionHide;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionImportData;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionJavaScript;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionLaunch;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionMovie;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionNamed;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRemoteGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionResetForm;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSound;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionSubmitForm;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionThread;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionURI;

public final class PDActionFactory {
    private PDActionFactory() {
    }

    public static PDAction createAction(COSDictionary action) {
        String type;
        PDAction retval = null;
        if (action != null && (type = action.getNameAsString(COSName.S)) != null) {
            switch (type) {
                case "JavaScript": {
                    retval = new PDActionJavaScript(action);
                    break;
                }
                case "GoTo": {
                    retval = new PDActionGoTo(action);
                    break;
                }
                case "Launch": {
                    retval = new PDActionLaunch(action);
                    break;
                }
                case "GoToR": {
                    retval = new PDActionRemoteGoTo(action);
                    break;
                }
                case "URI": {
                    retval = new PDActionURI(action);
                    break;
                }
                case "Named": {
                    retval = new PDActionNamed(action);
                    break;
                }
                case "Sound": {
                    retval = new PDActionSound(action);
                    break;
                }
                case "Movie": {
                    retval = new PDActionMovie(action);
                    break;
                }
                case "ImportData": {
                    retval = new PDActionImportData(action);
                    break;
                }
                case "ResetForm": {
                    retval = new PDActionResetForm(action);
                    break;
                }
                case "Hide": {
                    retval = new PDActionHide(action);
                    break;
                }
                case "SubmitForm": {
                    retval = new PDActionSubmitForm(action);
                    break;
                }
                case "Thread": {
                    retval = new PDActionThread(action);
                    break;
                }
                case "GoToE": {
                    retval = new PDActionEmbeddedGoTo(action);
                    break;
                }
            }
        }
        return retval;
    }
}

