/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.Objects;
import net.sourceforge.plantuml.abel.Entity;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.image.EntityImageState;
import net.sourceforge.plantuml.svek.image.EntityImageStateCommon;
import net.sourceforge.plantuml.url.Url;

public final class InnerStateAutonom
extends AbstractTextBlock
implements IEntityImage {
    private final IEntityImage im;
    private final TextBlock title;
    private final TextBlock attribute;
    private HColor borderColor;
    private HColor backColor;
    private final Url url;
    private final boolean withSymbol;
    private UStroke stroke;
    private final double rounded;
    private final double shadowing;
    private final HColor bodyColor;
    private final Style styleHeader;

    public InnerStateAutonom(IEntityImage im, Entity group) {
        this.im = Objects.requireNonNull(im);
        ISkinParam skinParam = group.getSkinParam();
        Style styleTitle = EntityImageStateCommon.getStyleStateTitle(group, skinParam);
        Style style = EntityImageStateCommon.getStyleState(group, skinParam);
        Style styleBody = EntityImageStateCommon.getStyleStateBody(group, skinParam);
        this.styleHeader = EntityImageStateCommon.getStyleStateHeader(group, skinParam);
        this.rounded = style.value(PName.RoundCorner).asDouble();
        this.shadowing = style.getShadowing();
        FontConfiguration titleFontConfiguration = styleTitle.getFontConfiguration(skinParam.getIHtmlColorSet());
        this.title = group.getDisplay().create(titleFontConfiguration, styleTitle.getHorizontalAlignment(), skinParam);
        this.attribute = group.getStateHeader(skinParam);
        this.withSymbol = group.getStereotype() != null && group.getStereotype().isWithOOSymbol();
        this.url = group.getUrl99();
        this.borderColor = group.getColors().getColor(ColorType.LINE);
        if (this.borderColor == null) {
            this.borderColor = style.value(PName.LineColor).asColor(skinParam.getIHtmlColorSet());
        }
        this.backColor = group.getColors().getColor(ColorType.BACK);
        if (this.backColor == null) {
            this.backColor = style.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
        }
        this.stroke = group.getColors().getSpecificLineStroke();
        if (this.stroke == null) {
            this.stroke = style.getStroke();
        }
        this.bodyColor = styleBody.value(PName.BackGroundColor).asColor(skinParam.getIHtmlColorSet());
    }

    @Override
    public void drawU(UGraphic ug) {
        XDimension2D text = this.title.calculateDimension(ug.getStringBounder());
        XDimension2D attr = this.attribute.calculateDimension(ug.getStringBounder());
        XDimension2D total = this.calculateDimension(ug.getStringBounder());
        double marginForFields = attr.getHeight() > 0.0 ? 5.0 : 0.0;
        double titreHeight = 5.0 + text.getHeight() + 5.0;
        RoundedContainer r = new RoundedContainer(total, titreHeight, attr.getHeight() + marginForFields, this.borderColor, this.backColor, this.bodyColor, this.stroke, this.rounded, this.shadowing);
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        r.drawU(ug);
        this.title.drawU(ug.apply(new UTranslate((total.getWidth() - text.getWidth()) / 2.0, 5.0)));
        HorizontalAlignment horizontalAlignment = this.styleHeader.getHorizontalAlignment();
        horizontalAlignment.draw(ug, this.attribute, 5.0, 5.0 + text.getHeight() + 5.0, total.getWidth());
        double spaceYforURL = this.getSpaceYforURL(ug.getStringBounder());
        this.im.drawU(ug.apply(new UTranslate(5.0, spaceYforURL)));
        if (this.withSymbol) {
            EntityImageState.drawSymbol(ug.apply(this.borderColor), total.getWidth(), total.getHeight());
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    private double getSpaceYforURL(StringBounder stringBounder) {
        XDimension2D text = this.title.calculateDimension(stringBounder);
        XDimension2D attr = this.attribute.calculateDimension(stringBounder);
        double marginForFields = attr.getHeight() > 0.0 ? 5.0 : 0.0;
        double titreHeight = 5.0 + text.getHeight() + 5.0;
        double suppY = titreHeight + marginForFields + attr.getHeight();
        return suppY + 5.0;
    }

    @Override
    public HColor getBackcolor() {
        return null;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D img = this.im.calculateDimension(stringBounder);
        XDimension2D text = this.title.calculateDimension(stringBounder);
        XDimension2D attr = this.attribute.calculateDimension(stringBounder);
        XDimension2D dim = text.mergeTB(attr, img);
        double marginForFields = attr.getHeight() > 0.0 ? 5.0 : 0.0;
        XDimension2D result = dim.delta(20.0 + marginForFields);
        return result;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.ROUND_RECTANGLE;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public boolean isHidden() {
        return this.im.isHidden();
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }
}

